/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.extractor;

import com.cloudconvert.client.mapper.ObjectMapperProvider;
import com.cloudconvert.dto.result.Result;
import com.cloudconvert.dto.result.Status;
import com.cloudconvert.exception.CloudConvertClientException;
import com.cloudconvert.exception.CloudConvertServerException;
import com.cloudconvert.processor.response.DefaultResponseProcessor;
import com.cloudconvert.processor.response.ResponseProcessor;
import com.cloudconvert.processor.response.successful.ContentResponseProcessor;
import com.cloudconvert.processor.response.successful.InputStreamResponseProcessor;
import com.cloudconvert.processor.response.successful.NoContentResponseProcessor;
import com.cloudconvert.resource.AbstractResource;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.io.EmptyInputStream;

public class ResultExtractor {
    private final ResponseProcessor defaultResponseProcessor;
    private final Map<TypeReference<?>, ResponseProcessor> responseProcessors;

    public ResultExtractor(ObjectMapperProvider objectMapperProvider) {
        ContentResponseProcessor contentResponseProcessor = new ContentResponseProcessor(objectMapperProvider);
        NoContentResponseProcessor noContentResponseProcessor = new NoContentResponseProcessor();
        InputStreamResponseProcessor inputStreamResponseProcessor = new InputStreamResponseProcessor();
        this.defaultResponseProcessor = new DefaultResponseProcessor();
        this.responseProcessors = ImmutableMap.builder().put(AbstractResource.VOID_TYPE_REFERENCE, (Object)noContentResponseProcessor).put(AbstractResource.INPUT_STREAM_TYPE_REFERENCE, (Object)inputStreamResponseProcessor).put(AbstractResource.MAP_STRING_TO_OBJECT_TYPE_REFERENCE, (Object)contentResponseProcessor).put(AbstractResource.TASK_RESPONSE_TYPE_REFERENCE, (Object)contentResponseProcessor).put(AbstractResource.JOB_RESPONSE_TYPE_REFERENCE, (Object)contentResponseProcessor).put(AbstractResource.USER_RESPONSE_TYPE_REFERENCE, (Object)contentResponseProcessor).put(AbstractResource.WEBHOOKS_RESPONSE_TYPE_REFERENCE, (Object)contentResponseProcessor).put(AbstractResource.OPERATION_RESPONSE_PAGEABLE_TYPE_REFERENCE, (Object)contentResponseProcessor).put(AbstractResource.TASK_RESPONSE_PAGEABLE_TYPE_REFERENCE, (Object)contentResponseProcessor).put(AbstractResource.JOB_RESPONSE_PAGEABLE_TYPE_REFERENCE, (Object)contentResponseProcessor).put(AbstractResource.WEBHOOKS_RESPONSE_PAGEABLE_TYPE_REFERENCE, (Object)contentResponseProcessor).build();
    }

    public <T> Result<T> extract(HttpResponse httpResponse, TypeReference<T> typeReference) throws IOException, CloudConvertClientException, CloudConvertServerException {
        StatusLine statusLine = httpResponse.getStatusLine();
        Status status = Status.builder().code(statusLine.getStatusCode()).reason(statusLine.getReasonPhrase()).build();
        Map<String, String> headers = Arrays.stream(httpResponse.getAllHeaders()).collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue, (v1, v2) -> String.valueOf(v1) + ", " + v2));
        HttpEntity httpEntity = Optional.ofNullable(httpResponse.getEntity()).orElse((HttpEntity)new InputStreamEntity((InputStream)EmptyInputStream.INSTANCE));
        Throwable throwable = null;
        Object var8_9 = null;
        try (InputStream inputStream = httpEntity.getContent();){
            if (status.isSuccessful()) {
                return this.responseProcessors.getOrDefault(typeReference, this.defaultResponseProcessor).process(status, headers, inputStream, typeReference);
            }
            if (status.isClientError()) {
                throw new CloudConvertClientException(status, headers, inputStream);
            }
            if (status.isServerError()) {
                throw new CloudConvertServerException(status, headers, inputStream);
            }
            return this.defaultResponseProcessor.process(status, headers, inputStream, typeReference);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

