/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.resource;

import com.cloudconvert.client.mapper.ObjectMapperProvider;
import com.cloudconvert.client.setttings.SettingsProvider;
import com.cloudconvert.dto.request.ConvertFilesTaskRequest;
import com.cloudconvert.dto.response.OperationResponse;
import com.cloudconvert.dto.response.Pageable;
import com.cloudconvert.dto.response.TaskResponse;
import com.cloudconvert.dto.result.AbstractResult;
import com.cloudconvert.exception.CloudConvertClientException;
import com.cloudconvert.exception.CloudConvertServerException;
import com.cloudconvert.resource.AbstractResource;
import com.cloudconvert.resource.params.Filter;
import com.cloudconvert.resource.params.Include;
import com.cloudconvert.resource.params.converter.AlternativeToNameValuePairsConverter;
import com.cloudconvert.resource.params.converter.FiltersToNameValuePairsConverter;
import com.cloudconvert.resource.params.converter.IncludesToNameValuePairsConverter;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConvertFilesResource<TRAR extends AbstractResult<TaskResponse>, ORP extends AbstractResult<Pageable<OperationResponse>>>
extends AbstractResource {
    public static final String PATH_SEGMENT_CONVERT = "convert";
    public static final String PATH_SEGMENT_FORMATS = "formats";
    private final IncludesToNameValuePairsConverter includesToNameValuePairsConverter = new IncludesToNameValuePairsConverter();
    private final FiltersToNameValuePairsConverter filtersToNameValuePairsConverter = new FiltersToNameValuePairsConverter();
    private final AlternativeToNameValuePairsConverter alternativeToNameValuePairsConverter = new AlternativeToNameValuePairsConverter();

    public AbstractConvertFilesResource(SettingsProvider settingsProvider, ObjectMapperProvider objectMapperProvider) {
        super(settingsProvider, objectMapperProvider);
    }

    public abstract TRAR convert(@NotNull ConvertFilesTaskRequest var1) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException;

    protected HttpUriRequest getConvertHttpUriRequest(@NotNull ConvertFilesTaskRequest convertFilesTaskRequest) throws IOException, URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_CONVERT));
        HttpEntity httpEntity = this.getHttpEntity(convertFilesTaskRequest);
        return this.getHttpUriRequest(HttpPost.class, uri, httpEntity);
    }

    public abstract ORP convertFormats() throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException;

    public abstract ORP convertFormats(@NotNull Map<Filter, String> var1) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException;

    public abstract ORP convertFormats(@NotNull Map<Filter, String> var1, @NotNull List<Include> var2) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException;

    public abstract ORP convertFormats(@NotNull Map<Filter, String> var1, @NotNull List<Include> var2, @Nullable Boolean var3) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException;

    protected HttpUriRequest getConvertFormatsHttpUriRequest(@NotNull Map<Filter, String> filters, @NotNull List<Include> includes, @Nullable Boolean alternative) throws IOException, URISyntaxException {
        ImmutableList nameValuePairs = ImmutableList.builder().addAll(this.filtersToNameValuePairsConverter.convert(filters)).addAll(this.includesToNameValuePairsConverter.convert(includes)).addAll(this.alternativeToNameValuePairsConverter.convert(alternative)).build();
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_CONVERT, (Object)PATH_SEGMENT_FORMATS), (List<NameValuePair>)nameValuePairs);
        return this.getHttpUriRequest(HttpGet.class, uri);
    }
}

