/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.resource;

import com.cloudconvert.client.mapper.ObjectMapperProvider;
import com.cloudconvert.client.setttings.SettingsProvider;
import com.cloudconvert.dto.request.WebhookRequest;
import com.cloudconvert.dto.response.Pageable;
import com.cloudconvert.dto.response.WebhookResponse;
import com.cloudconvert.dto.result.AbstractResult;
import com.cloudconvert.exception.CloudConvertClientException;
import com.cloudconvert.exception.CloudConvertServerException;
import com.cloudconvert.resource.AbstractResource;
import com.cloudconvert.resource.params.Filter;
import com.cloudconvert.resource.params.Pagination;
import com.cloudconvert.resource.params.converter.FiltersToNameValuePairsConverter;
import com.cloudconvert.resource.params.converter.PaginationToNameValuePairsConverter;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWebhooksResource<WRAR extends AbstractResult<WebhookResponse>, WRPAR extends AbstractResult<Pageable<WebhookResponse>>, VAR extends AbstractResult<Void>>
extends AbstractResource {
    public static final String HMAC_SHA256 = "HmacSHA256";
    public static final String PATH_SEGMENT_WEBHOOKS = "webhooks";
    private final FiltersToNameValuePairsConverter filtersToNameValuePairsConverter = new FiltersToNameValuePairsConverter();
    private final PaginationToNameValuePairsConverter paginationToNameValuePairsConverter = new PaginationToNameValuePairsConverter();

    public AbstractWebhooksResource(SettingsProvider settingsProvider, ObjectMapperProvider objectMapperProvider) {
        super(settingsProvider, objectMapperProvider);
    }

    public abstract WRAR create(@NotNull WebhookRequest var1) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException;

    protected HttpUriRequest getCreateHttpUriRequest(@NotNull WebhookRequest webhookRequest) throws IOException, URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_WEBHOOKS));
        HttpEntity httpEntity = this.getHttpEntity(webhookRequest);
        return this.getHttpUriRequest(HttpPost.class, uri, httpEntity);
    }

    public abstract WRPAR list() throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException;

    public abstract WRPAR list(@NotNull Map<Filter, String> var1) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException;

    public abstract WRPAR list(@NotNull Map<Filter, String> var1, @Nullable Pagination var2) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException;

    protected HttpUriRequest getListHttpUriRequest(@NotNull Map<Filter, String> filters, @Nullable Pagination pagination) throws URISyntaxException {
        ImmutableList nameValuePairs = ImmutableList.builder().addAll(this.filtersToNameValuePairsConverter.convert(filters)).addAll(this.paginationToNameValuePairsConverter.convert(pagination)).build();
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)"users", (Object)"me", (Object)PATH_SEGMENT_WEBHOOKS), (List<NameValuePair>)nameValuePairs);
        return this.getHttpUriRequest(HttpGet.class, uri);
    }

    public abstract VAR delete(@NotNull String var1) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException;

    protected HttpUriRequest getDeleteHttpUriRequest(@NotNull String webhookId) throws URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_WEBHOOKS, (Object)webhookId));
        return this.getHttpUriRequest(HttpDelete.class, uri);
    }

    public boolean verify(@NotNull String payload, @NotNull String signature) throws InvalidKeyException, NoSuchAlgorithmException {
        Mac mac = Mac.getInstance(HMAC_SHA256);
        SecretKeySpec secretKeySpec = new SecretKeySpec(this.getSettingsProvider().getWebhookSigningSecret().getBytes(), HMAC_SHA256);
        mac.init(secretKeySpec);
        return signature.equals(Hex.encodeHexString((byte[])mac.doFinal(payload.getBytes())));
    }
}

