/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.resource.sync;

import com.cloudconvert.client.mapper.ObjectMapperProvider;
import com.cloudconvert.client.setttings.SettingsProvider;
import com.cloudconvert.dto.request.AddWatermarkTaskRequest;
import com.cloudconvert.dto.request.CaptureWebsitesTaskRequest;
import com.cloudconvert.dto.request.ConvertFilesTaskRequest;
import com.cloudconvert.dto.request.CreateArchivesTaskRequest;
import com.cloudconvert.dto.request.CreateThumbnailsTaskRequest;
import com.cloudconvert.dto.request.ExecuteCommandsTaskRequest;
import com.cloudconvert.dto.request.GetMetadataTaskRequest;
import com.cloudconvert.dto.request.MergeFilesTaskRequest;
import com.cloudconvert.dto.request.OptimizeFilesTaskRequest;
import com.cloudconvert.dto.request.WriteMetadataTaskRequest;
import com.cloudconvert.dto.response.OperationResponse;
import com.cloudconvert.dto.response.Pageable;
import com.cloudconvert.dto.response.TaskResponse;
import com.cloudconvert.dto.result.Result;
import com.cloudconvert.exception.CloudConvertClientException;
import com.cloudconvert.exception.CloudConvertServerException;
import com.cloudconvert.executor.RequestExecutor;
import com.cloudconvert.resource.AbstractTasksResource;
import com.cloudconvert.resource.params.Filter;
import com.cloudconvert.resource.params.Include;
import com.cloudconvert.resource.params.Pagination;
import com.cloudconvert.resource.sync.AddWatermarkResource;
import com.cloudconvert.resource.sync.CaptureWebsitesResource;
import com.cloudconvert.resource.sync.ConvertFilesResource;
import com.cloudconvert.resource.sync.CreateArchivesResource;
import com.cloudconvert.resource.sync.CreateThumbnailsResource;
import com.cloudconvert.resource.sync.ExecuteCommandsResource;
import com.cloudconvert.resource.sync.GetMetadataResource;
import com.cloudconvert.resource.sync.MergeFilesResource;
import com.cloudconvert.resource.sync.OptimizeFilesResource;
import com.cloudconvert.resource.sync.WriteMetadataResource;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TasksResource
extends AbstractTasksResource<Result<TaskResponse>, Result<Pageable<TaskResponse>>, Result<Void>, Result<Pageable<OperationResponse>>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TasksResource.class);
    private final RequestExecutor requestExecutor;

    public TasksResource(SettingsProvider settingsProvider, ObjectMapperProvider objectMapperProvider, RequestExecutor requestExecutor, ConvertFilesResource convertFilesResource, OptimizeFilesResource optimizeFilesResource, CaptureWebsitesResource captureWebsitesResource, MergeFilesResource mergeFilesResource, CreateArchivesResource createArchivesResource, ExecuteCommandsResource executeCommandsResource, CreateThumbnailsResource createThumbnailsResource, GetMetadataResource getMetadataResource, WriteMetadataResource writeMetadataResource, AddWatermarkResource addWatermarkResource) {
        super(settingsProvider, objectMapperProvider, convertFilesResource, optimizeFilesResource, captureWebsitesResource, mergeFilesResource, createArchivesResource, executeCommandsResource, createThumbnailsResource, getMetadataResource, writeMetadataResource, addWatermarkResource);
        this.requestExecutor = requestExecutor;
    }

    @Override
    public Result<TaskResponse> show(@NotNull String taskId) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return this.show(taskId, (List)ImmutableList.of());
    }

    @Override
    public Result<TaskResponse> show(@NotNull String taskId, @NotNull List<Include> includes) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return this.requestExecutor.execute(this.getShowHttpUriRequest(taskId, includes), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public Result<TaskResponse> wait(@NotNull String taskId) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return this.requestExecutor.execute(this.getWaitHttpUriRequest(taskId), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public Result<Pageable<TaskResponse>> list() throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return this.list((Map)ImmutableMap.of());
    }

    @Override
    public Result<Pageable<TaskResponse>> list(@NotNull Map<Filter, String> filters) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return this.list((Map)filters, (List)ImmutableList.of());
    }

    @Override
    public Result<Pageable<TaskResponse>> list(@NotNull Map<Filter, String> filters, @NotNull List<Include> includes) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return this.list((Map)filters, (List)includes, (Pagination)null);
    }

    @Override
    public Result<Pageable<TaskResponse>> list(@NotNull Map<Filter, String> filters, @NotNull List<Include> includes, @Nullable Pagination pagination) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return this.requestExecutor.execute(this.getListHttpUriRequest(filters, includes, pagination), TASK_RESPONSE_PAGEABLE_TYPE_REFERENCE);
    }

    @Override
    public Result<TaskResponse> cancel(@NotNull String taskId) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return this.requestExecutor.execute(this.getCancelHttpUriRequest(taskId), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public Result<TaskResponse> retry(@NotNull String taskId) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return this.requestExecutor.execute(this.getRetryHttpUriRequest(taskId), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public Result<Void> delete(@NotNull String taskId) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return this.requestExecutor.execute(this.getDeleteHttpUriRequest(taskId), VOID_TYPE_REFERENCE);
    }

    @Override
    public Result<Pageable<OperationResponse>> operations() throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return this.operations((Map)ImmutableMap.of());
    }

    @Override
    public Result<Pageable<OperationResponse>> operations(@NotNull Map<Filter, String> filters) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return this.operations((Map)filters, (List)ImmutableList.of());
    }

    @Override
    public Result<Pageable<OperationResponse>> operations(@NotNull Map<Filter, String> filters, @NotNull List<Include> includes) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return this.operations((Map)filters, (List)includes, (Boolean)null);
    }

    @Override
    public Result<Pageable<OperationResponse>> operations(@NotNull Map<Filter, String> filters, @NotNull List<Include> includes, @Nullable Boolean alternative) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return this.requestExecutor.execute(this.getOperationsHttpUriRequest(filters, includes, alternative), OPERATION_RESPONSE_PAGEABLE_TYPE_REFERENCE);
    }

    @Override
    public Result<TaskResponse> convert(@NotNull ConvertFilesTaskRequest convertFilesTaskRequest) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return (Result)this.getAbstractConvertFilesResource().convert(convertFilesTaskRequest);
    }

    @Override
    public Result<Pageable<OperationResponse>> convertFormats() throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return (Result)this.getAbstractConvertFilesResource().convertFormats();
    }

    @Override
    public Result<Pageable<OperationResponse>> convertFormats(@NotNull Map<Filter, String> filters) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return (Result)this.getAbstractConvertFilesResource().convertFormats(filters);
    }

    @Override
    public Result<Pageable<OperationResponse>> convertFormats(@NotNull Map<Filter, String> filters, @NotNull List<Include> includes) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return (Result)this.getAbstractConvertFilesResource().convertFormats(filters, includes);
    }

    @Override
    public Result<Pageable<OperationResponse>> convertFormats(@NotNull Map<Filter, String> filters, @NotNull List<Include> includes, @Nullable Boolean alternative) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return (Result)this.getAbstractConvertFilesResource().convertFormats(filters, includes, alternative);
    }

    @Override
    public Result<TaskResponse> optimize(@NotNull OptimizeFilesTaskRequest optimizeFilesTaskRequest) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return (Result)this.getAbstractOptimizeFilesResource().optimize(optimizeFilesTaskRequest);
    }

    @Override
    public Result<TaskResponse> capture(@NotNull CaptureWebsitesTaskRequest captureWebsitesTaskRequest) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return (Result)this.getAbstractCaptureWebsitesResource().capture(captureWebsitesTaskRequest);
    }

    @Override
    public Result<TaskResponse> merge(@NotNull MergeFilesTaskRequest mergeFilesTaskRequest) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return (Result)this.getAbstractMergeFilesResource().merge(mergeFilesTaskRequest);
    }

    @Override
    public Result<TaskResponse> archive(@NotNull CreateArchivesTaskRequest createArchivesTaskRequest) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return (Result)this.getAbstractCreateArchivesResource().archive(createArchivesTaskRequest);
    }

    @Override
    public Result<TaskResponse> command(@NotNull ExecuteCommandsTaskRequest executeCommandsTaskRequest) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return (Result)this.getAbstractExecuteCommandsResource().command(executeCommandsTaskRequest);
    }

    @Override
    public Result<TaskResponse> thumbnail(@NotNull CreateThumbnailsTaskRequest createThumbnailsTaskRequest) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return (Result)this.getAbstractCreateThumbnailsResource().thumbnail(createThumbnailsTaskRequest);
    }

    @Override
    public Result<TaskResponse> metadata(@NotNull GetMetadataTaskRequest getMetadataTaskRequest) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return (Result)this.getAbstractGetMetadataResource().metadata(getMetadataTaskRequest);
    }

    @Override
    public Result<TaskResponse> writeMetadata(@NotNull WriteMetadataTaskRequest writeMetadataTaskRequest) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return (Result)this.getAbstractWriteMetadataResource().writeMetadata(writeMetadataTaskRequest);
    }

    @Override
    public Result<TaskResponse> watermark(@NotNull AddWatermarkTaskRequest addWatermarkTaskRequest) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return (Result)this.getAbstractAddWatermarkResource().watermark(addWatermarkTaskRequest);
    }

    @Override
    public void close() throws IOException {
        this.requestExecutor.close();
        super.close();
    }
}

