/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.codegen4j;

import com.cloudimpl.codegen4j.AccessLevel;
import com.cloudimpl.codegen4j.CodeBlock;
import com.cloudimpl.codegen4j.ConstructorBlock;
import com.cloudimpl.codegen4j.FunctionBlock;
import com.cloudimpl.codegen4j.PermissionBlock;
import com.cloudimpl.codegen4j.Statement;
import com.cloudimpl.codegen4j.Var;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ClassBlock
extends PermissionBlock {
    private String packageName;
    private List<String> imports = new LinkedList<String>();
    protected String className = null;
    private String extend = null;
    protected List<String> implementList;

    public ClassBlock(String name) {
        this.className = name;
        this.implementList = Collections.EMPTY_LIST;
    }

    public String getClassName() {
        return this.className;
    }

    public ClassBlock extend(String className) {
        this.extend = className;
        return this;
    }

    public ClassBlock withPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public ClassBlock withImports(String ... imports) {
        Arrays.asList(imports).forEach(imp -> this.imports.add((String)imp));
        return this;
    }

    public ClassBlock implement(String ... clsList) {
        this.implementList = Arrays.asList(clsList);
        return this;
    }

    public ClassBlock createClass(String name) {
        return (ClassBlock)this.pushBlock(new ClassBlock(name));
    }

    public ConstructorBlock createConstructor(String ... args) {
        return (ConstructorBlock)this.pushBlock(new ConstructorBlock(this.className, args));
    }

    public FunctionBlock createFunction(String functionName) {
        return (FunctionBlock)this.pushBlock(new FunctionBlock(functionName));
    }

    public void emptyBlock() {
        this.pushBlock(new CodeBlock(){

            @Override
            protected Statement generateHeader() {
                return null;
            }
        });
    }

    public FunctionBlock createGetter(Var var) {
        FunctionBlock func = new FunctionBlock("get" + ("" + var.var.charAt(0)).toUpperCase() + var.var.substring(1));
        func.stmt().append("return").append2("this.").append(var.var).end();
        this.pushBlock((CodeBlock)func.withReturnType(var.type).withAccess(AccessLevel.PUBLIC));
        return func;
    }

    public void createSetter(Var var) {
        FunctionBlock func = new FunctionBlock("set" + ("" + var.var.charAt(0)).toUpperCase() + var.var.substring(1)).withArgs(var.type + " " + var.var);
        func.stmt().append2("this.").append(var.var).append("=").append(var.var).end();
        this.pushBlock((CodeBlock)func.withAccess(AccessLevel.PUBLIC));
    }

    @Override
    protected Statement generateHeader() {
        return this.stmt().append(this.level).append(this.isStatic, "static").append(this.isFinal, "final").append("class").append(this.className).append(this.extend != null, "extends " + this.extend).append(!this.implementList.isEmpty(), "implements " + String.join((CharSequence)",", this.implementList));
    }
}

