/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.codegen4j;

import com.cloudimpl.codegen4j.ClassBlock;
import com.cloudimpl.codegen4j.ClassBuilder;
import com.cloudimpl.codegen4j.EnumBlock;
import com.cloudimpl.codegen4j.EnumStatement;
import com.cloudimpl.codegen4j.Statement;
import com.cloudimpl.codegen4j.Var;
import java.util.LinkedList;
import java.util.List;

public abstract class CodeBlock {
    private List<Statement> stmts = new LinkedList<Statement>();
    private List<CodeBlock> codeBlocks = new LinkedList<CodeBlock>();
    private List<String> annotations = new LinkedList<String>();

    public static String createName(String prefix, String name) {
        return prefix + name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
    }

    protected void addStmt(Statement stmt) {
        this.stmts.add(stmt);
    }

    private boolean hasEnumConstant() {
        return this.stmts.stream().filter(st -> st instanceof EnumStatement).findAny().orElse(null) != null;
    }

    public <T extends CodeBlock> T withAnnotation(String annotation) {
        this.annotations.add("@" + annotation);
        return (T)this;
    }

    public Statement stmt() {
        return new Statement(this);
    }

    protected <T> T pushBlock(CodeBlock block) {
        this.codeBlocks.add(block);
        return (T)block;
    }

    public Var var(String type, String var) {
        return new Var(this, type, var);
    }

    protected abstract Statement generateHeader();

    public void generateCode(int tabIndex, StringBuilder builder) {
        int beginTab = tabIndex;
        Statement header = this.generateHeader();
        if (header != null) {
            this.annotations.forEach(s -> {
                ClassBuilder.tab(builder, beginTab);
                builder.append((String)s).append("\r\n");
            });
            ClassBuilder.tab(builder, beginTab);
            builder.append(header.toString());
        } else {
            ClassBuilder.tab(builder, beginTab);
        }
        builder.append("{").append("\r\n");
        int temp = ++tabIndex;
        if (this instanceof EnumBlock && !this.hasEnumConstant()) {
            ClassBuilder.tab(builder, temp);
            builder.append(";").append("\r\n");
        }
        this.stmts.forEach(stmt -> {
            stmt.getAnnotations().forEach(s -> {
                ClassBuilder.tab(builder, temp);
                builder.append((String)s).append("\r\n");
            });
            ClassBuilder.tab(builder, temp);
            builder.append(stmt.toString()).append("\r\n");
        });
        this.codeBlocks.sort((arg0, arg1) -> {
            if (arg0.getClass() == arg1.getClass()) {
                return 0;
            }
            if (arg0.getClass() == ClassBlock.class || arg0.getClass() == EnumBlock.class) {
                return 1;
            }
            return 0;
        });
        int temp2 = tabIndex--;
        this.codeBlocks.forEach(cb -> {
            builder.append("\r\n");
            cb.generateCode(temp2, builder);
        });
        ClassBuilder.tab(builder, beginTab);
        builder.append("}").append("\r\n");
    }
}

