/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.codegen4j;

import com.cloudimpl.codegen4j.ClassBlock;
import java.io.File;
import java.io.FileWriter;

public class JavaFile {
    private final ClassBlock block;

    private JavaFile(ClassBlock block) {
        this.block = block;
    }

    public static JavaFile wrap(ClassBlock block) {
        return new JavaFile(block);
    }

    public String writeTo(File folder) {
        if (!folder.isDirectory()) {
            throw new RuntimeException(folder + " is not a directory");
        }
        String path = folder.getAbsolutePath();
        if (this.block.getPackageName() != null) {
            path = path + "/" + this.block.getPackageName().replaceAll("\\.", "/");
        }
        File dir = new File(path);
        dir.mkdirs();
        String javaFile = dir.getAbsoluteFile() + "/" + this.block.getClassName() + ".java";
        try (FileWriter writer = new FileWriter(javaFile);){
            writer.write(this.generateCode());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return javaFile;
    }

    public String generateCode() {
        StringBuilder builder = new StringBuilder();
        int tabIndex = 0;
        if (this.block.getPackageName() != null) {
            builder.append("package ").append(this.block.getPackageName()).append(";").append("\r\n").append("\r\n");
        }
        this.block.getImports().forEach(imp -> builder.append("import ").append((String)imp).append(";").append("\r\n"));
        builder.append("\r\n");
        this.block.generateCode(tabIndex, builder);
        return builder.toString();
    }
}

