/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.codegen4j.spi;

import com.cloudimpl.codegen4j.spi.CodeGenException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public abstract class MavenCodeGenSpi {
    private final Map<String, String> properties = new HashMap<String, String>();
    private final String namespace;
    private Project project;
    private final String projectName;
    private final String propertyPrefix;
    private final Set<String> artifacts = new HashSet<String>();
    private Optional<String> classPath = Optional.empty();
    private List<String> runtimeClasspathElements = new LinkedList<String>();
    private ClassLoader classLoader;
    private boolean classLoaderInit = false;

    public MavenCodeGenSpi(String projectName, String namespace) {
        this.namespace = namespace;
        this.projectName = projectName;
        this.propertyPrefix = this.namespace + "." + this.projectName + ".";
    }

    protected void addProperty(String key, String value) {
        if (key.startsWith(this.propertyPrefix)) {
            this.properties.put(key.substring(this.propertyPrefix.length()), value);
        }
    }

    protected void addDependacyPath(String path, boolean runtime) {
        if (!runtime) {
            this.artifacts.add(path);
        } else {
            this.runtimeClasspathElements.add(path);
        }
    }

    protected void addClassPath(String artifact) {
        String regex = artifact.replaceAll("\\.", "/");
        this.classPath = this.artifacts.stream().filter(s -> s.contains(regex)).findFirst();
    }

    protected Class loadClass(String className) {
        try {
            if (this.classLoader == null) {
                this.classLoader = this.getClassLoader();
            }
            Class<?> cls = this.classLoader.loadClass(className);
            return cls;
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MavenCodeGenSpi.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    private ClassLoader getClassLoader() {
        URL[] runtimeUrls = new URL[this.runtimeClasspathElements.size()];
        for (int i = 0; i < this.runtimeClasspathElements.size(); ++i) {
            try {
                String element = this.runtimeClasspathElements.get(i);
                runtimeUrls[i] = new File(element).toURI().toURL();
                continue;
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(MavenCodeGenSpi.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        URLClassLoader newLoader = new URLClassLoader(runtimeUrls, Thread.currentThread().getContextClassLoader());
        return newLoader;
    }

    public String getCodeGenFolder() {
        return this.project.getBuildDir() + "/generated-sources/" + this.projectName;
    }

    public void setProject(String baseDir, String buildDir, String buildTargetDir) {
        this.project = new Project(baseDir, buildDir, buildTargetDir);
    }

    public Project getProject() {
        return this.project;
    }

    public String getProperty(String prop, String defaultValue) {
        String val = this.properties.get(prop);
        if (val == null && defaultValue == null) {
            throw new CodeGenException("property :" + prop + " not found");
        }
        if (val == null) {
            val = defaultValue;
        }
        return val;
    }

    public boolean hasProperty(String prop) {
        return this.properties.containsKey(prop);
    }

    protected void compileFiles(File ... files) {
        this.compileFiles(Arrays.asList(files));
    }

    protected void compileFiles(List<File> javaFiles) {
        if (javaFiles.isEmpty()) {
            return;
        }
        this.log("compiling files: " + javaFiles.stream().map(f -> f.getAbsolutePath()).collect(Collectors.toList()));
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(javaFiles);
        ArrayList<String> optionList = new ArrayList<String>();
        if (this.classPath.isPresent()) {
            optionList.addAll(Arrays.asList("-classpath", this.classPath.get()));
        }
        File targetDir = new File(this.project.getBuildTargetDir());
        targetDir.mkdir();
        optionList.addAll(Arrays.asList("-d", this.project.getBuildTargetDir()));
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, optionList, null, compilationUnits);
        try {
            boolean ok = task.call();
            this.log("files compile status " + ok);
            diagnostics.getDiagnostics().stream().forEach(System.out::println);
            if (!ok) {
                throw new RuntimeException("error compiling file");
            }
            fileManager.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (!this.classLoaderInit) {
            this.addSoftwareLibrary(new File(this.project.getBuildTargetDir()));
            this.classLoaderInit = true;
        }
    }

    protected void log(String log) {
        System.out.println(log);
    }

    private void addSoftwareLibrary(File file) {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)this.getClass().getClassLoader(), file.toURI().toURL());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | MalformedURLException ex) {
            Logger.getLogger(MavenCodeGenSpi.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public abstract void execute();

    public static final class Project {
        private final String baseDir;
        private final String buildDir;
        private final String buildTargetDir;

        public Project(String baseDir, String buildDir, String buildTargetDir) {
            this.baseDir = baseDir;
            this.buildDir = buildDir;
            this.buildTargetDir = buildTargetDir + "/";
        }

        public String getBaseDir() {
            return this.baseDir;
        }

        public String getBuildDir() {
            return this.buildDir;
        }

        public String getBuildTargetDir() {
            return this.buildTargetDir;
        }

        public String toString() {
            return "Project{baseDir=" + this.baseDir + ", buildDir=" + this.buildDir + ", buildTargetDir=" + this.buildTargetDir + '}';
        }
    }
}

