/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.app;

import com.cloudimpl.outstack.domain.example.Organization;
import com.cloudimpl.outstack.domain.example.commands.OrganizationLogoUploadRequest;
import com.cloudimpl.outstack.runtime.EnableFileUpload;
import com.cloudimpl.outstack.runtime.EntityCommandHandler;
import com.cloudimpl.outstack.runtime.EntityContext;
import com.cloudimpl.outstack.spring.controller.exception.ResourceNotFoundException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.codec.multipart.FilePart;

@EnableFileUpload(mimeTypes={"image/jpeg"})
public class UploadOrganizationLogo
extends EntityCommandHandler<Organization, OrganizationLogoUploadRequest, Organization> {
    private static final Logger log = LoggerFactory.getLogger(UploadOrganizationLogo.class);

    protected Organization execute(EntityContext<Organization> context, OrganizationLogoUploadRequest command) {
        log.info("Receiving files for the organization : {}", (Object)command.rootId());
        Optional optionalRootEntity = context.asRootContext().getEntityById(command.rootId());
        if (optionalRootEntity.isEmpty()) {
            throw new ResourceNotFoundException("Organization {0} not exists", new Object[]{command.rootId()});
        }
        command.getFiles().forEach(e -> {
            if (e instanceof FilePart) {
                FilePart filePart = (FilePart)e;
                log.info("Received : {}", (Object)filePart.filename());
            }
        });
        return new Organization("xxxx-logo-upload-example-org");
    }
}

