/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.app;

import com.cloudimpl.outstack.domain.example.Tenant;
import com.cloudimpl.outstack.domain.example.commands.TenantLogUploadRequest;
import com.cloudimpl.outstack.runtime.EnableFileUpload;
import com.cloudimpl.outstack.runtime.EntityCommandHandler;
import com.cloudimpl.outstack.runtime.EntityContext;
import com.cloudimpl.outstack.spring.controller.exception.ResourceNotFoundException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.codec.multipart.FilePart;

@EnableFileUpload(mimeTypes={"image/jpeg"})
public class UploadTenantLogo
extends EntityCommandHandler<Tenant, TenantLogUploadRequest, Tenant> {
    private static final Logger log = LoggerFactory.getLogger(UploadTenantLogo.class);

    protected Tenant execute(EntityContext<Tenant> context, TenantLogUploadRequest command) {
        log.info("Receiving files for the tenant : {}", (Object)command.id());
        Optional optionalChildEntity = context.asChildContext().getEntityById(command.id());
        if (optionalChildEntity.isEmpty()) {
            throw new ResourceNotFoundException("Tenant {0} not exists", new Object[]{command.rootId()});
        }
        command.getFiles().forEach(e -> {
            if (e instanceof FilePart) {
                FilePart filePart = (FilePart)e;
                log.info("Received : {}", (Object)filePart.filename());
            }
        });
        return new Tenant("xxxx-logo-upload-example-ten");
    }
}

