/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.component;

import com.cloudimpl.outstack.app.AppConfig;
import com.cloudimpl.outstack.collection.CollectionOptions;
import com.cloudimpl.outstack.common.CloudMessage;
import com.cloudimpl.outstack.common.CloudMessageDecoder;
import com.cloudimpl.outstack.common.CloudMessageEncoder;
import com.cloudimpl.outstack.common.GsonCodec;
import com.cloudimpl.outstack.core.CloudUtil;
import com.cloudimpl.outstack.core.Injector;
import com.cloudimpl.outstack.core.ServiceRegistryReadOnly;
import com.cloudimpl.outstack.logger.ConsoleLogWriter;
import com.cloudimpl.outstack.logger.LogWriter;
import com.cloudimpl.outstack.node.CloudNode;
import com.cloudimpl.outstack.runtime.CommandWrapper;
import com.cloudimpl.outstack.runtime.CommandWrapperHelper;
import com.cloudimpl.outstack.runtime.EventRepositoryFactory;
import com.cloudimpl.outstack.runtime.QueryWrapper;
import com.cloudimpl.outstack.runtime.QueryWrapperHelper;
import com.cloudimpl.outstack.runtime.ResourceHelper;
import com.cloudimpl.outstack.runtime.ValidationErrorException;
import com.cloudimpl.outstack.runtime.domainspec.AuthInput;
import com.cloudimpl.outstack.spring.component.ResourcesLoaderEx;
import com.cloudimpl.outstack.spring.component.SpringApplicationConfigManager;
import com.cloudimpl.outstack.spring.security.PlatformAuthenticationToken;
import com.cloudimpl.outstack.spring.security.PolicyStatementValidator;
import com.cloudimpl.outstack.spring.service.ServiceDescriptorContextManager;
import com.cloudimpl.outstack.spring.service.config.ConfigQueryProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component(value="OUTSTACK_CLUSTER")
public class Cluster {
    private static final Logger log = LoggerFactory.getLogger(Cluster.class);
    private CloudNode node;
    @Autowired
    private ServiceDescriptorContextManager serviceDescriptorContextMan;
    @Autowired
    private SpringApplicationConfigManager configManager;
    @Autowired
    private AutowireCapableBeanFactory beanFactory;
    @Autowired
    private PolicyStatementValidator policyValidator;
    private ResourceHelper resourceHelper;
    private static AutowireCapableBeanFactory beanFactoryInstance;
    private Injector injector;
    private static Cluster instance;

    @PostConstruct
    public void init() {
        instance = this;
        beanFactoryInstance = this.beanFactory;
        this.injector = new Injector();
        this.configManager.setInjector(this.injector);
        this.resourceHelper = new ResourceHelper(this.configManager.getDomainOwner(), this.configManager.getDomainContext(), this.configManager.getApiContext());
        Cluster.autoWireInstance().accept(this);
        this.injector.bind(ResourceHelper.class).to((Object)this.resourceHelper);
        AppConfig appConfig = AppConfig.builder().withGossipPort(this.configManager.getCluster().getGossipPort()).withSeeds((String[])this.configManager.getCluster().getSeeds().toArray(String[]::new)).withSeedName(this.configManager.getCluster().getSeedName()).withServicePort(this.configManager.getCluster().getServicePort()).build();
        this.injector.bind(ServiceDescriptorContextManager.class).to((Object)this.serviceDescriptorContextMan);
        this.injector.bind(LogWriter.class).to((Object)new ConsoleLogWriter());
        this.bindVars(this.injector);
        ConfigQueryProvider.getInstance().setEventRepositroy((EventRepositoryFactory)this.injector.getInjecterbleInstance(EventRepositoryFactory.class));
        this.injector.nameBind("leaderOptions", (Object)CollectionOptions.builder().withOption("TableName", (Object)"Test").build());
        ResourcesLoaderEx serviceLoader = new ResourcesLoaderEx(this.resourceHelper);
        serviceLoader.preload();
        appConfig.getNodeConfigBuilder().doOnNext(c -> c.withServiceEndpoints(serviceLoader.getEndpoints())).map(C -> C.build()).doOnNext(c -> {
            this.node = new CloudNode(this.injector, c);
            serviceLoader.init(this.node);
            this.node.start();
        }).subscribe();
    }

    private void bindVars(Injector injector) {
        this.configManager.getProviders().stream().forEach(p -> {
            Object instance = p.getInstance();
            if (p.getStatus().isPresent() && p.getStatus().get().equals("active")) {
                injector.bind(CloudUtil.classForName((String)p.getBase())).to(instance);
                injector.bind(p.getName()).to(instance);
            } else {
                injector.bind(p.getName()).to(instance);
            }
        });
    }

    public static Consumer<Object> autoWireInstance() {
        return instance::inject;
    }

    private void inject(Object instance) {
        beanFactoryInstance.autowireBean(instance);
        this.injector.inject(instance);
    }

    @PreDestroy
    public void shutdown() {
        if (this.node != null) {
            this.node.shutdown();
        }
        System.exit(-1);
    }

    public ServiceRegistryReadOnly getServiceRegistry() {
        return this.node.getServiceRegistry();
    }

    public ServiceDescriptorContextManager getServiceDescriptorContextManager() {
        return this.serviceDescriptorContextMan;
    }

    public <T> Mono<T> requestReply(ServerHttpRequest httpRequest, String serviceName, Object msg) {
        if (msg instanceof CommandWrapper) {
            CommandWrapper wrapper = (CommandWrapper)CommandWrapper.class.cast(msg);
            return ReactiveSecurityContextHolder.getContext().map(c -> c.getAuthentication()).cast(PlatformAuthenticationToken.class).doOnNext(c -> this.validateTenantId((PlatformAuthenticationToken)((Object)c), httpRequest)).doOnNext(c -> this.populateAttributes((PlatformAuthenticationToken)((Object)c), httpRequest, wrapper)).map(t -> this.policyValidator.processPolicyStatementsForCommand((AuthInput)wrapper, (PlatformAuthenticationToken)((Object)t))).doOnNext(g -> wrapper.setGrant(g)).flatMap(g -> this.node.requestReply(serviceName, msg)).switchIfEmpty(Mono.defer(() -> this.node.requestReply(serviceName, msg))).map(o -> o);
        }
        if (msg instanceof QueryWrapper) {
            QueryWrapper wrapper = (QueryWrapper)QueryWrapper.class.cast(msg);
            return ReactiveSecurityContextHolder.getContext().map(c -> c.getAuthentication()).cast(PlatformAuthenticationToken.class).doOnNext(c -> this.validateTenantId((PlatformAuthenticationToken)((Object)c), httpRequest)).doOnNext(c -> this.populateAttributes((PlatformAuthenticationToken)((Object)c), httpRequest, wrapper)).map(t -> this.policyValidator.processPolicyStatementsForQuery((AuthInput)wrapper, (PlatformAuthenticationToken)((Object)t))).doOnNext(g -> wrapper.setGrant(g)).flatMap(g -> this.node.requestReply(serviceName, msg)).switchIfEmpty(Mono.defer(() -> this.node.requestReply(serviceName, msg))).map(o -> o);
        }
        return this.node.requestReply(serviceName, msg);
    }

    public <T> Flux<T> requestStream(String serviceName, Object msg) {
        return this.node.requestStream(serviceName, msg);
    }

    public Mono<Void> send(String serviceName, Object msg) {
        return this.node.send(serviceName, msg);
    }

    private void populateAttributes(PlatformAuthenticationToken token, ServerHttpRequest httpRequest, CommandWrapper wrapper) {
        HashMap<String, String> mapAttr = new HashMap<String, String>();
        if (httpRequest != null) {
            mapAttr.put("@remoteIp", httpRequest.getRemoteAddress().toString());
        }
        mapAttr.putAll(token.getJwtToken().getClaims().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> String.valueOf(entry.getValue()))));
        String headerTenantId = httpRequest.getHeaders().getFirst("X-TenantId");
        String tokenTenantId = (String)token.getJwtToken().getClaim("tenantId");
        CommandWrapperHelper.withTenantId((CommandWrapper)wrapper, (String)(tokenTenantId != null ? tokenTenantId : headerTenantId));
        CommandWrapperHelper.withContext((CommandWrapper)wrapper, (String)((String)token.getJwtToken().getClaim("ctx")));
        CommandWrapperHelper.withMapAttr((CommandWrapper)wrapper, mapAttr);
    }

    private void validateTenantId(PlatformAuthenticationToken token, ServerHttpRequest httpRequest) {
        String headerTenantId = httpRequest.getHeaders().getFirst("X-TenantId");
        String tokenTenantId = (String)token.getJwtToken().getClaim("tenantId");
        if (tokenTenantId != null && headerTenantId != null && !tokenTenantId.equals(headerTenantId)) {
            log.error("Tenant identifier violation");
            throw new ValidationErrorException("Tenant identifier violation");
        }
    }

    private void populateAttributes(PlatformAuthenticationToken token, ServerHttpRequest httpRequest, QueryWrapper wrapper) {
        HashMap<String, String> mapAttr = new HashMap<String, String>();
        if (httpRequest != null) {
            mapAttr.put("@remoteIp", httpRequest.getRemoteAddress().toString());
        }
        mapAttr.putAll(token.getJwtToken().getClaims().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> String.valueOf(entry.getValue()))));
        String headerTenantId = httpRequest.getHeaders().getFirst("X-TenantId");
        String tokenTenantId = (String)token.getJwtToken().getClaim("tenantId");
        QueryWrapperHelper.withTenantId((QueryWrapper)wrapper, (String)(tokenTenantId != null ? tokenTenantId : headerTenantId));
        QueryWrapperHelper.withContext((QueryWrapper)wrapper, (String)((String)token.getJwtToken().getClaim("ctx")));
        QueryWrapperHelper.withMapAttr((QueryWrapper)wrapper, mapAttr);
    }

    static {
        GsonCodec.registerTypeAdaptor(CloudMessage.class, () -> new CloudMessageDecoder(), () -> new CloudMessageEncoder());
    }
}

