/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.component;

import com.cloudimpl.outstack.core.Injector;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public class SpringInjector
extends Injector {
    private final AutowireCapableBeanFactory beanFactory;

    public SpringInjector(AutowireCapableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public <T> T inject(Class<T> clazz) {
        Object instance = super.inject(clazz);
        this.beanFactory.autowireBean(instance);
        return (T)instance;
    }

    public void inject(Object injectableObject) {
        super.inject(injectableObject);
        this.beanFactory.autowireBean(injectableObject);
    }
}

