/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.component;

import com.cloudimpl.outstack.common.CloudMessage;
import com.cloudimpl.outstack.core.Inject;
import com.cloudimpl.outstack.core.Named;
import com.cloudimpl.outstack.runtime.CommandHandler;
import com.cloudimpl.outstack.runtime.EntityCommandHandler;
import com.cloudimpl.outstack.runtime.EntityEventHandler;
import com.cloudimpl.outstack.runtime.EventRepositoryFactory;
import com.cloudimpl.outstack.runtime.Handler;
import com.cloudimpl.outstack.runtime.ServiceProvider;
import com.cloudimpl.outstack.runtime.domainspec.ChildEntity;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import com.cloudimpl.outstack.runtime.util.Util;
import com.cloudimpl.outstack.spring.component.Cluster;
import com.cloudimpl.outstack.spring.component.SpringQueryService;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class SpringService<T extends RootEntity>
implements Function<CloudMessage, Publisher> {
    private static final Set<Class<? extends CommandHandler<?>>> HANDLERS = new HashSet();
    private static final Set<Class<? extends Entity>> CMD_ENTITIES = new HashSet<Class<? extends Entity>>();
    private final ServiceProvider<T, CloudMessage> serviceProvider;
    @Inject
    @Named(value="RRHnd")
    private BiFunction<String, Object, Mono> requestHandler;

    public SpringService(EventRepositoryFactory factory) {
        System.out.println("service :" + this.getClass().getName() + " factory : " + factory);
        Class root = Util.extractGenericParameter(this.getClass(), SpringService.class, (int)0);
        this.serviceProvider = new ServiceProvider(root, factory.createOrGetRepository(root), arg_0 -> ((EventRepositoryFactory)factory).createOrGetRepository(arg_0), () -> this.requestHandler, () -> Cluster.autoWireInstance());
        HANDLERS.stream().filter(h -> SpringService.filter(root, h)).filter(h -> EntityCommandHandler.class.isAssignableFrom((Class<?>)h)).forEach(e -> this.serviceProvider.registerCommandHandler(e));
        HANDLERS.stream().filter(h -> SpringService.filter(root, h)).filter(h -> EntityEventHandler.class.isAssignableFrom((Class<?>)h)).forEach(e -> this.serviceProvider.registerEventHandler(e));
        CMD_ENTITIES.stream().filter(e -> SpringQueryService.filterEntity(root, e)).forEach(e -> this.serviceProvider.registerDefaultCmdHandlersForEntity(e));
    }

    public static void $(Class<? extends CommandHandler<?>> handler) {
        HANDLERS.add(handler);
    }

    public static void $$(Class<? extends Entity> entityType) {
        CMD_ENTITIES.add(entityType);
    }

    @Override
    public Publisher apply(CloudMessage msg) {
        return this.serviceProvider.apply(msg.data());
    }

    public static boolean filter(Class<? extends RootEntity> rootType, Class<? extends Handler<?>> handlerType) {
        Class entityType = Util.extractGenericParameter(handlerType, handlerType.getSuperclass(), (int)0);
        Class root = RootEntity.isMyType((Class)entityType) ? entityType : Util.extractGenericParameter((Class)entityType, ChildEntity.class, (int)0);
        return rootType == root;
    }

    public static Collection<Class<? extends Entity>> queryEntities(Class<? extends RootEntity> rootType) {
        return CMD_ENTITIES.stream().filter(h -> SpringQueryService.filterEntity(rootType, h)).collect(Collectors.toList());
    }

    public static Collection<Class<? extends CommandHandler<?>>> handlers(Class<? extends RootEntity> rootType) {
        return HANDLERS.stream().filter(h -> SpringService.filter(rootType, h)).collect(Collectors.toList());
    }

    public static Collection<Class<? extends Entity>> cmdEntities(Class<? extends RootEntity> rootType) {
        return CMD_ENTITIES.stream().filter(h -> SpringQueryService.filterEntity(rootType, h)).collect(Collectors.toList());
    }
}

