/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.component;

import com.cloudimpl.outstack.common.Pair;
import com.cloudimpl.outstack.runtime.domainspec.TenantRequirement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class SpringServiceDescriptor {
    private final Map<String, ActionDescriptor> rootActions;
    private final Map<String, Map<String, ActionDescriptor>> childActions;
    private final Map<String, EntityDescriptor> mapDescriptors;
    private final EntityDescriptor rootDesc;
    private final String version;
    private final TenantRequirement tenancy;
    private final String serviceName;
    private final String domainOwner;
    private final String domainContext;
    private final String apiContext;

    public SpringServiceDescriptor(String apiContext, String domainOwner, String domainContext, String serviceName, String rootType, String version, String plural, TenantRequirement tenancy) {
        this.apiContext = apiContext;
        this.serviceName = serviceName;
        this.domainContext = domainContext;
        this.domainOwner = domainOwner;
        this.rootDesc = new EntityDescriptor(rootType, plural);
        this.version = version;
        this.tenancy = tenancy;
        this.rootActions = new HashMap<String, ActionDescriptor>();
        this.childActions = new HashMap<String, Map<String, ActionDescriptor>>();
        this.mapDescriptors = new HashMap<String, EntityDescriptor>();
    }

    public Collection<ActionDescriptor> getRootActions() {
        return this.rootActions.values();
    }

    public Collection<ActionDescriptor> getChildActions(String childEntity) {
        return this.childActions.getOrDefault(childEntity, Collections.EMPTY_MAP).values();
    }

    public Collection<Pair<String, ActionDescriptor>> getChildActions() {
        return this.childActions.entrySet().stream().flatMap(e -> ((Map)e.getValue()).values().stream().map(v -> new Pair((Object)((String)e.getKey()), v))).collect(Collectors.toList());
    }

    public Collection<EntityDescriptor> entityDescriptors() {
        return this.mapDescriptors.values();
    }

    public EntityDescriptor getEntityDescByName(String type) {
        return this.mapDescriptors.values().stream().filter(d -> d.getName().equals(type)).findFirst().get();
    }

    public void putRootAction(ActionDescriptor action) {
        this.rootActions.put(action.getName(), action);
    }

    public String getApiContext() {
        return this.apiContext;
    }

    public void putChildAction(EntityDescriptor child, ActionDescriptor action) {
        this.mapDescriptors.put(child.getPlural().toLowerCase(), child);
        Map<String, ActionDescriptor> map = this.childActions.get(child.getName());
        if (map == null) {
            map = new HashMap<String, ActionDescriptor>();
            this.childActions.put(child.getName(), map);
        }
        map.put(action.getName(), action);
    }

    public TenantRequirement getTenancy() {
        return this.tenancy;
    }

    public Optional<EntityDescriptor> getEntityDescriptorByPlural(String plural) {
        return Optional.ofNullable(this.mapDescriptors.get(plural.toLowerCase()));
    }

    public String getPlural() {
        return this.rootDesc.getPlural().toLowerCase();
    }

    public String getVersion() {
        return this.version;
    }

    public String getRootType() {
        return this.rootDesc.getName();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getDomainOwner() {
        return this.domainOwner;
    }

    public String getDomainContext() {
        return this.domainContext;
    }

    public Optional<ActionDescriptor> getRootAction(String action) {
        return Optional.ofNullable(this.rootActions.get(action));
    }

    public Optional<ActionDescriptor> getChildAction(String child, String action) {
        return Optional.ofNullable(this.childActions.get(child)).map(m -> (ActionDescriptor)m.get(action));
    }

    public static final class EntityDescriptor {
        private final String name;
        private final String plural;

        public EntityDescriptor(String name, String plural) {
            this.name = name;
            this.plural = plural;
        }

        public String getName() {
            return this.name;
        }

        public String getPlural() {
            return this.plural;
        }

        public int hashCode() {
            int hash = 3;
            hash = 89 * hash + Objects.hashCode(this.plural);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntityDescriptor other = (EntityDescriptor)obj;
            return Objects.equals(this.plural, other.plural);
        }
    }

    public static final class ActionDescriptor {
        private final String name;
        private final ActionType actionType;
        private final boolean idRequired;
        private final boolean publiclyAccessible;
        private final boolean fileUploadEnabled;
        private final Set<String> mimeTypes;

        public ActionDescriptor(String name, boolean idRequired, boolean publiclyAccessible, ActionType actionType) {
            this.name = name;
            this.actionType = actionType;
            this.idRequired = idRequired;
            this.publiclyAccessible = publiclyAccessible;
            this.fileUploadEnabled = false;
            this.mimeTypes = Collections.emptySet();
        }

        public ActionDescriptor(String name, boolean idRequired, ActionType actionType, boolean publiclyAccessible, boolean fileUploadEnabled, Set<String> mimeTypes) {
            this.name = name;
            this.idRequired = idRequired;
            this.actionType = actionType;
            this.publiclyAccessible = publiclyAccessible;
            this.fileUploadEnabled = fileUploadEnabled;
            this.mimeTypes = mimeTypes;
        }

        public String getName() {
            return this.name;
        }

        public boolean isIdRequired() {
            return this.idRequired;
        }

        public ActionType getActionType() {
            return this.actionType;
        }

        public boolean isPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public boolean isFileUploadEnabled() {
            return this.fileUploadEnabled;
        }

        public Set<String> getMimeTypes() {
            return this.mimeTypes;
        }

        public static enum ActionType {
            COMMAND_HANDLER,
            EVENT_HANDLER,
            QUERY_HANDLER;

        }
    }
}

