/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.controller;

public class ControllerStat {
    private String serviceName;
    private String action;
    private String rootType;
    private String rootId;
    private String childType;
    private String childId;
    private long startTime;
    private long checkpointTime;

    public ControllerStat(String serviceName, String action, String rootType) {
        this.serviceName = serviceName;
        this.action = action;
        this.rootType = rootType;
        this.startTime = System.currentTimeMillis();
    }

    public String stats() {
        long diff = System.currentTimeMillis() - this.startTime;
        StringBuilder builder = new StringBuilder();
        builder.append("service: [").append(this.serviceName).append("] action = [").append(this.action).append("] rootType = [").append(this.rootType).append("] rootId = [").append(this.rootId).append("] childType = [").append(this.childType).append("] childId = [").append(this.childId).append("] time = [").append(this.checkpointTime).append("][").append(diff).append("]");
        return builder.toString();
    }

    public void checkpoint() {
        this.checkpointTime = System.currentTimeMillis() - this.startTime;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getAction() {
        return this.action;
    }

    public String getRootType() {
        return this.rootType;
    }

    public String getRootId() {
        return this.rootId;
    }

    public String getChildType() {
        return this.childType;
    }

    public String getChildId() {
        return this.childId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getCheckpointTime() {
        return this.checkpointTime;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setRootType(String rootType) {
        this.rootType = rootType;
    }

    public void setRootId(String rootId) {
        this.rootId = rootId;
    }

    public void setChildType(String childType) {
        this.childType = childType;
    }

    public void setChildId(String childId) {
        this.childId = childId;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setCheckpointTime(long checkpointTime) {
        this.checkpointTime = checkpointTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ControllerStat)) {
            return false;
        }
        ControllerStat other = (ControllerStat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.getCheckpointTime() != other.getCheckpointTime()) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$rootType = this.getRootType();
        String other$rootType = other.getRootType();
        if (this$rootType == null ? other$rootType != null : !this$rootType.equals(other$rootType)) {
            return false;
        }
        String this$rootId = this.getRootId();
        String other$rootId = other.getRootId();
        if (this$rootId == null ? other$rootId != null : !this$rootId.equals(other$rootId)) {
            return false;
        }
        String this$childType = this.getChildType();
        String other$childType = other.getChildType();
        if (this$childType == null ? other$childType != null : !this$childType.equals(other$childType)) {
            return false;
        }
        String this$childId = this.getChildId();
        String other$childId = other.getChildId();
        return !(this$childId == null ? other$childId != null : !this$childId.equals(other$childId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ControllerStat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        long $checkpointTime = this.getCheckpointTime();
        result = result * 59 + (int)($checkpointTime >>> 32 ^ $checkpointTime);
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $rootType = this.getRootType();
        result = result * 59 + ($rootType == null ? 43 : $rootType.hashCode());
        String $rootId = this.getRootId();
        result = result * 59 + ($rootId == null ? 43 : $rootId.hashCode());
        String $childType = this.getChildType();
        result = result * 59 + ($childType == null ? 43 : $childType.hashCode());
        String $childId = this.getChildId();
        result = result * 59 + ($childId == null ? 43 : $childId.hashCode());
        return result;
    }

    public String toString() {
        return "ControllerStat(serviceName=" + this.getServiceName() + ", action=" + this.getAction() + ", rootType=" + this.getRootType() + ", rootId=" + this.getRootId() + ", childType=" + this.getChildType() + ", childId=" + this.getChildId() + ", startTime=" + this.getStartTime() + ", checkpointTime=" + this.getCheckpointTime() + ")";
    }
}

