/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.repo;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.ItemCollection;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.internal.IteratorSupport;
import com.amazonaws.services.dynamodbv2.document.spec.QuerySpec;
import com.amazonaws.services.dynamodbv2.document.utils.ValueMap;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Delete;
import com.amazonaws.services.dynamodbv2.model.Put;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ReturnValuesOnConditionCheckFailure;
import com.amazonaws.services.dynamodbv2.model.TransactWriteItem;
import com.amazonaws.services.dynamodbv2.model.TransactWriteItemsRequest;
import com.amazonaws.services.dynamodbv2.model.Update;
import com.cloudimpl.outstack.common.GsonCodec;
import com.cloudimpl.outstack.core.ComponentProvider;
import com.cloudimpl.outstack.runtime.EntityCheckpoint;
import com.cloudimpl.outstack.runtime.EntityIdHelper;
import com.cloudimpl.outstack.runtime.EventRepositoy;
import com.cloudimpl.outstack.runtime.ResourceHelper;
import com.cloudimpl.outstack.runtime.ResultSet;
import com.cloudimpl.outstack.runtime.domainspec.ChildEntity;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.Query;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import com.cloudimpl.outstack.runtime.domainspec.TenantRequirement;
import com.cloudimpl.outstack.runtime.repo.EventRepoUtil;
import com.cloudimpl.outstack.runtime.repo.RepositoryException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class DynamodbEventRepository<T extends RootEntity>
extends EventRepositoy<T> {
    private final ComponentProvider.ProviderConfigs configs;
    private final DynamoDB dynamodb;
    private final AmazonDynamoDB client;
    private String entityTable;
    private String eventTable;
    public static final String partitionKeyColumn = "partitionKey";
    public static final String rangeKeyColumn = "rangeKey";
    public static final String jsonColumn = "json";
    public static final String lastSeqColumn = "lastSeq";
    public static final String eventTypeColumn = "eventType";
    public static final String eventOwnerColumn = "eventOwner";
    public static final String ownerIdColumn = "ownerId";
    private final String tableName;
    ThreadLocal<List<TransactWriteItem>> txContext = ThreadLocal.withInitial(() -> new LinkedList());

    public DynamodbEventRepository(AmazonDynamoDB client, DynamoDB dynamodb, Class<T> rootType, ResourceHelper resourceHelper, ComponentProvider.ProviderConfigs configs) {
        super(rootType, resourceHelper);
        this.dynamodb = dynamodb;
        this.client = client;
        this.configs = configs;
        this.tableName = (String)this.configs.getOption(rootType.getSimpleName() + "Table").or(() -> this.configs.getOption("defaultTable")).get();
        System.out.println("table name " + this.tableName + " pick for root type: " + rootType.getSimpleName());
    }

    protected void startTransaction() {
        List<TransactWriteItem> list = this.txContext.get();
        list.clear();
    }

    protected void endTransaction() {
        TransactWriteItemsRequest transaction = new TransactWriteItemsRequest().withTransactItems((Collection)this.txContext.get()).withReturnConsumedCapacity(ReturnConsumedCapacity.TOTAL);
        try {
            this.client.transactWriteItems(transaction);
            System.out.println("Transaction Successful");
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    protected void saveRootEntityBrnIfNotExist(RootEntity e) {
        String rn = this.resourceHelper.getFQBrn(e.getBRN());
        String prefix = rn.substring(0, rn.lastIndexOf("/"));
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put(partitionKeyColumn, new AttributeValue(prefix));
        item.put(rangeKeyColumn, new AttributeValue(rn));
        item.put(jsonColumn, new AttributeValue(GsonCodec.encode((Object)e)));
        item.put(lastSeqColumn, new AttributeValue().withN(String.valueOf(e.getMeta().getLastSeq())));
        Put createEntity = new Put().withTableName(this.tableName).withItem(item).withReturnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure.ALL_OLD).withConditionExpression("attribute_not_exists(" + rangeKeyColumn + ")");
        this.txContext.get().add(new TransactWriteItem().withPut(createEntity));
    }

    protected void saveRootEntityTrnIfNotExist(RootEntity e) {
        String trn = this.resourceHelper.getFQTrn(e.getTRN());
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put(partitionKeyColumn, new AttributeValue(trn));
        item.put(rangeKeyColumn, new AttributeValue(trn));
        item.put(jsonColumn, new AttributeValue(GsonCodec.encode((Object)e)));
        item.put(lastSeqColumn, new AttributeValue().withN(String.valueOf(e.getMeta().getLastSeq())));
        Put createEntity = new Put().withTableName(this.tableName).withItem(item).withReturnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure.ALL_OLD).withConditionExpression("attribute_not_exists(" + partitionKeyColumn + ")");
        this.txContext.get().add(new TransactWriteItem().withPut(createEntity));
    }

    protected void saveRootEntityBrnIfExist(long lastSeq, RootEntity e) {
        String rn = this.resourceHelper.getFQBrn(e.getBRN());
        String prefix = rn.substring(0, rn.lastIndexOf("/"));
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put(partitionKeyColumn, new AttributeValue(prefix));
        item.put(rangeKeyColumn, new AttributeValue(rn));
        HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
        expressionAttributeValues.put(":lastSeq", new AttributeValue().withN(String.valueOf(e.getMeta().getLastSeq())));
        expressionAttributeValues.put(":checkLastSeq", new AttributeValue().withN(String.valueOf(lastSeq)));
        expressionAttributeValues.put(":json", new AttributeValue(GsonCodec.encode((Object)e)));
        Update updateEntity = new Update().withTableName(this.tableName).withKey(item).withUpdateExpression("SET json = :json , lastSeq = :lastSeq").withExpressionAttributeValues(expressionAttributeValues).withConditionExpression("lastSeq = :checkLastSeq and attribute_exists(" + rangeKeyColumn + ")").withReturnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure.ALL_OLD);
        this.txContext.get().add(new TransactWriteItem().withUpdate(updateEntity));
    }

    protected void saveRootEntityTrnIfExist(long lastSeq, RootEntity e) {
        String trn = this.resourceHelper.getFQTrn(e.getTRN());
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put(partitionKeyColumn, new AttributeValue(trn));
        item.put(rangeKeyColumn, new AttributeValue(trn));
        HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
        expressionAttributeValues.put(":lastSeq", new AttributeValue().withN(String.valueOf(e.getMeta().getLastSeq())));
        expressionAttributeValues.put(":checkLastSeq", new AttributeValue().withN(String.valueOf(lastSeq)));
        expressionAttributeValues.put(":json", new AttributeValue(GsonCodec.encode((Object)e)));
        Update updateEntity = new Update().withTableName(this.tableName).withKey(item).withUpdateExpression("SET json = :json , lastSeq = :lastSeq").withExpressionAttributeValues(expressionAttributeValues).withConditionExpression("lastSeq = :checkLastSeq and attribute_exists(" + rangeKeyColumn + ")").withReturnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure.ALL_OLD);
        this.txContext.get().add(new TransactWriteItem().withUpdate(updateEntity));
    }

    protected void saveChildEntityBrnIfNotExist(ChildEntity e) {
        String partitionKey = this.resourceHelper.getFQTrn(e.getRootTRN());
        String rangeKey = this.resourceHelper.getFQBrn(e.getBRN());
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put(partitionKeyColumn, new AttributeValue(partitionKey));
        item.put(rangeKeyColumn, new AttributeValue(rangeKey));
        item.put(jsonColumn, new AttributeValue(GsonCodec.encode((Object)e)));
        item.put(lastSeqColumn, new AttributeValue().withN(String.valueOf(e.getMeta().getLastSeq())));
        Put createEntity = new Put().withTableName(this.tableName).withItem(item).withReturnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure.ALL_OLD).withConditionExpression("attribute_not_exists(" + rangeKeyColumn + ")");
        this.txContext.get().add(new TransactWriteItem().withPut(createEntity));
    }

    protected void saveChildEntityTrnIfNotExist(ChildEntity e) {
        String partitionKey = this.resourceHelper.getFQTrn(e.getRootTRN());
        String rangeKey = this.resourceHelper.getFQTrn(e.getTRN());
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put(partitionKeyColumn, new AttributeValue(partitionKey));
        item.put(rangeKeyColumn, new AttributeValue(rangeKey));
        item.put(jsonColumn, new AttributeValue(GsonCodec.encode((Object)e)));
        item.put(lastSeqColumn, new AttributeValue().withN(String.valueOf(e.getMeta().getLastSeq())));
        Put createEntity = new Put().withTableName(this.tableName).withItem(item).withReturnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure.ALL_OLD).withConditionExpression("attribute_not_exists(" + rangeKeyColumn + ")");
        this.txContext.get().add(new TransactWriteItem().withPut(createEntity));
    }

    protected void saveChildEntityBrnIfExist(long lastSeq, ChildEntity e) {
        String partitionKey = this.resourceHelper.getFQTrn(e.getRootTRN());
        String rangeKey = this.resourceHelper.getFQBrn(e.getBRN());
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put(partitionKeyColumn, new AttributeValue(partitionKey));
        item.put(rangeKeyColumn, new AttributeValue(rangeKey));
        HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
        expressionAttributeValues.put(":lastSeq", new AttributeValue().withN(String.valueOf(e.getMeta().getLastSeq())));
        expressionAttributeValues.put(":checkLastSeq", new AttributeValue().withN(String.valueOf(lastSeq)));
        expressionAttributeValues.put(":json", new AttributeValue(GsonCodec.encode((Object)e)));
        Update updateEntity = new Update().withTableName(this.tableName).withKey(item).withUpdateExpression("SET json = :json , lastSeq = :lastSeq").withExpressionAttributeValues(expressionAttributeValues).withConditionExpression("lastSeq = :checkLastSeq and attribute_exists(" + rangeKeyColumn + ")").withReturnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure.ALL_OLD);
        this.txContext.get().add(new TransactWriteItem().withUpdate(updateEntity));
    }

    protected void saveChildEntityTrnIfExist(long lastSeq, ChildEntity e) {
        String partitionKey = this.resourceHelper.getFQTrn(e.getRootTRN());
        String rangeKey = this.resourceHelper.getFQTrn(e.getTRN());
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put(partitionKeyColumn, new AttributeValue(partitionKey));
        item.put(rangeKeyColumn, new AttributeValue(rangeKey));
        HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
        expressionAttributeValues.put(":lastSeq", new AttributeValue().withN(String.valueOf(e.getMeta().getLastSeq())));
        expressionAttributeValues.put(":checkLastSeq", new AttributeValue().withN(String.valueOf(lastSeq)));
        expressionAttributeValues.put(":json", new AttributeValue(GsonCodec.encode((Object)e)));
        Update updateEntity = new Update().withTableName(this.tableName).withKey(item).withUpdateExpression("SET json = :json , lastSeq = :lastSeq").withExpressionAttributeValues(expressionAttributeValues).withConditionExpression("lastSeq = :checkLastSeq and attribute_exists(" + rangeKeyColumn + ")").withReturnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure.ALL_OLD);
        this.txContext.get().add(new TransactWriteItem().withUpdate(updateEntity));
    }

    protected void deleteRootEntityBrnById(RootEntity e, boolean deleteOnlyEntity) {
        String rn = this.resourceHelper.getFQBrn(RootEntity.makeRN(e.getClass(), (String)this.version, (String)e.entityId(), (String)e.getTenantId()));
        String prefix = rn.substring(0, rn.lastIndexOf("/"));
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put(partitionKeyColumn, new AttributeValue(prefix));
        item.put(rangeKeyColumn, new AttributeValue(rn));
        Delete delete = new Delete().withTableName(this.tableName).withKey(item);
        this.txContext.get().add(new TransactWriteItem().withDelete(delete));
    }

    protected void deleteRootEntityTrnById(Class<T> rootType, String id, String tenantId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected <C extends ChildEntity<T>> void deleteChildEntityBrnById(ChildEntity e, boolean deleteOnlyEntity) {
        String partitionKey = this.resourceHelper.getFQTrn(RootEntity.makeTRN((Class)this.rootType, (String)this.version, (String)e.id(), (String)e.getTenantId()));
        String rangeKey = this.resourceHelper.getFQBrn(ChildEntity.makeRN((Class)this.rootType, (String)this.version, (String)e.rootId(), e.getClass(), (String)e.id(), (String)e.getTenantId()));
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put(partitionKeyColumn, new AttributeValue(partitionKey));
        item.put(rangeKeyColumn, new AttributeValue(rangeKey));
        Delete delete = new Delete().withTableName(this.tableName).withKey(item);
        this.txContext.get().add(new TransactWriteItem().withDelete(delete));
    }

    protected <C extends ChildEntity<T>> void deleteChildEntityTrnById(Class<T> rootType, String id, Class<C> childType, String childId, String tenantId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected Optional<EntityCheckpoint> _getCheckpoint(String rootTrn) {
        String partitionKey = this.resourceHelper.getFQTrn(rootTrn);
        HashMap<String, String> expressionAttributesNames = new HashMap<String, String>();
        expressionAttributesNames.put("#partitionKey", partitionKeyColumn);
        expressionAttributesNames.put("#rangeKey", rangeKeyColumn);
        expressionAttributesNames.put("#json", jsonColumn);
        HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
        expressionAttributeValues.put(":partitionKey", new AttributeValue().withS(partitionKey));
        expressionAttributeValues.put(":rangeKey", new AttributeValue().withS(EntityCheckpoint.class.getSimpleName()));
        QueryRequest queryRequest = new QueryRequest().withTableName(this.tableName).withKeyConditionExpression("partitionKey = :partitionKey AND rangeKey = :rangeKey").withExpressionAttributeValues(expressionAttributeValues);
        QueryResult queryResult = this.client.query(queryRequest);
        List items = queryResult.getItems();
        if (items.size() > 0) {
            return Optional.of((EntityCheckpoint)GsonCodec.decode(EntityCheckpoint.class, (String)((AttributeValue)((Map)items.get(0)).get(jsonColumn)).getS()));
        }
        return Optional.of(new EntityCheckpoint(rootTrn).setSeq(0L));
    }

    protected void addEvent(Event event) {
        String trn = this.resourceHelper.getFQTrn(event.getRootEntityTRN() + "/events");
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put(partitionKeyColumn, new AttributeValue(trn));
        item.put(rangeKeyColumn, new AttributeValue(String.format("%019d", event.getSeqNum())));
        item.put(jsonColumn, new AttributeValue(GsonCodec.encodeWithType((Object)event)));
        item.put(lastSeqColumn, new AttributeValue().withN(String.valueOf(event.getSeqNum())));
        item.put(eventTypeColumn, new AttributeValue(event.getClass().getSimpleName()));
        item.put(eventOwnerColumn, new AttributeValue(event.getOwner().getSimpleName()));
        item.put(ownerIdColumn, new AttributeValue(event.id()));
        Put createEvent = new Put().withTableName(this.tableName).withItem(item).withConditionExpression("attribute_not_exists(" + rangeKeyColumn + ")").withReturnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure.ALL_OLD);
        this.txContext.get().add(new TransactWriteItem().withPut(createEvent));
    }

    private String getRootBrn(Class<T> rootType, String tenantId) {
        String trn = null;
        TenantRequirement tenantReq = Entity.checkTenantRequirement(rootType);
        switch (tenantReq) {
            case REQUIRED: {
                trn = this.resourcePrefix("brn") + ":tenant/" + tenantId + "/" + this.version + "/" + rootType.getSimpleName();
                break;
            }
            case OPTIONAL: {
                if (tenantId != null) {
                    trn = this.resourcePrefix("brn") + ":tenant/" + tenantId + "/" + this.version + "/" + rootType.getSimpleName();
                    break;
                }
                trn = this.resourcePrefix("brn") + ":" + this.version + "/" + rootType.getSimpleName();
                break;
            }
            default: {
                trn = this.resourcePrefix("brn") + ":" + this.version + "/" + rootType.getSimpleName();
            }
        }
        return trn;
    }

    private <C extends ChildEntity<T>> String getChildBrn(Class<T> rootType, String id, Class<C> childType, String tenantId) {
        EntityIdHelper.validateTechnicalId((String)id);
        String trn = null;
        TenantRequirement tenantReq = Entity.checkTenantRequirement(rootType);
        switch (tenantReq) {
            case REQUIRED: {
                trn = this.resourcePrefix("brn") + ":tenant/" + tenantId + "/" + this.version + "/" + rootType.getSimpleName() + "/" + id + "/" + childType.getSimpleName() + "/";
                break;
            }
            case OPTIONAL: {
                if (tenantId != null) {
                    trn = this.resourcePrefix("brn") + ":tenant/" + tenantId + "/" + this.version + "/" + rootType.getSimpleName() + "/" + id + "/" + childType.getSimpleName() + "/";
                    break;
                }
                trn = this.resourcePrefix("brn") + ":" + this.version + "/" + rootType.getSimpleName() + "/" + id + "/" + childType.getSimpleName() + "/";
                break;
            }
            default: {
                trn = this.resourcePrefix("brn") + ":" + this.version + "/" + rootType.getSimpleName() + "/" + id + "/" + childType.getSimpleName() + "/";
            }
        }
        return trn;
    }

    public ResultSet<T> getAllByRootType(Class<T> rootType, String tenantId, Query.PagingRequest paging) {
        String partitionKey = this.getRootBrn(rootType, tenantId);
        Table table = this.dynamodb.getTable(this.tableName);
        QuerySpec querySpec = new QuerySpec().withKeyConditionExpression("partitionKey = :partitionKey").withValueMap((Map)new ValueMap().withString(":partitionKey", partitionKey)).withConsistentRead(true);
        ItemCollection query = table.query(querySpec);
        IteratorSupport iterator = query.iterator();
        Iterable iterable = () -> DynamodbEventRepository.lambda$getAllByRootType$2((Iterator)iterator);
        List items = StreamSupport.stream(iterable.spliterator(), false).map(attr -> (RootEntity)GsonCodec.decode((Class)rootType, (String)attr.getString(jsonColumn))).filter(i -> EventRepoUtil.onFilter((Object)i, (Map)paging.getParams())).collect(Collectors.toList());
        return EventRepoUtil.onPageable(items, (Query.PagingRequest)paging);
    }

    public ResultSet<T> getAllByRootType(Class<T> rootType, Collection<String> tenantId, Query.PagingRequest paging) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Optional<T> getRootById(Class<T> rootType, String id, String tenantId) {
        String rKey;
        String pKey;
        if (EntityIdHelper.isTechnicalId((String)id)) {
            rKey = pKey = this.resourceHelper.getFQTrn(RootEntity.makeTRN(rootType, (String)this.version, (String)id, (String)tenantId));
        } else {
            pKey = this.getRootBrn(rootType, tenantId);
            rKey = this.resourceHelper.getFQBrn(RootEntity.makeRN(rootType, (String)this.version, (String)id, (String)tenantId));
        }
        HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
        expressionAttributeValues.put(":partitionKey", new AttributeValue().withS(pKey));
        expressionAttributeValues.put(":rangeKey", new AttributeValue().withS(rKey));
        QueryRequest queryRequest = new QueryRequest().withTableName(this.tableName).withKeyConditionExpression("partitionKey = :partitionKey AND rangeKey = :rangeKey").withExpressionAttributeValues(expressionAttributeValues);
        QueryResult queryResult = this.client.query(queryRequest);
        List items = queryResult.getItems();
        if (items.size() > 0) {
            return Optional.of((RootEntity)GsonCodec.decode(rootType, (String)((AttributeValue)((Map)items.get(0)).get(jsonColumn)).getS()));
        }
        return Optional.empty();
    }

    public <C extends ChildEntity<T>> Optional<C> getChildById(Class<T> rootType, String id, Class<C> childType, String childId, String tenantId) {
        EntityIdHelper.validateTechnicalId((String)id);
        String pKey = this.resourceHelper.getFQTrn(RootEntity.makeTRN(rootType, (String)this.version, (String)id, (String)tenantId));
        String rKey = EntityIdHelper.isTechnicalId((String)childId) ? this.resourceHelper.getFQTrn(ChildEntity.makeTRN(rootType, (String)this.version, (String)id, childType, (String)childId, (String)tenantId)) : this.resourceHelper.getFQBrn(ChildEntity.makeRN(rootType, (String)this.version, (String)id, childType, (String)childId, (String)tenantId));
        HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
        expressionAttributeValues.put(":partitionKey", new AttributeValue().withS(pKey));
        expressionAttributeValues.put(":rangeKey", new AttributeValue().withS(rKey));
        QueryRequest queryRequest = new QueryRequest().withTableName(this.tableName).withKeyConditionExpression("partitionKey = :partitionKey AND rangeKey = :rangeKey").withExpressionAttributeValues(expressionAttributeValues);
        QueryResult queryResult = this.client.query(queryRequest);
        List items = queryResult.getItems();
        if (items.size() > 0) {
            return Optional.of((ChildEntity)GsonCodec.decode(childType, (String)((AttributeValue)((Map)items.get(0)).get(jsonColumn)).getS()));
        }
        return Optional.empty();
    }

    public <C extends ChildEntity<T>> ResultSet<C> getAllChildByType(Class<T> rootType, String id, Class<C> childType, String tenantId, Query.PagingRequest paging) {
        String pKey = this.resourceHelper.getFQTrn(RootEntity.makeTRN(rootType, (String)this.version, (String)id, (String)tenantId));
        String rkey = this.getChildBrn(rootType, id, childType, tenantId);
        Table table = this.dynamodb.getTable(this.tableName);
        QuerySpec querySpec = new QuerySpec().withKeyConditionExpression("partitionKey = :partitionKey AND begins_with(rangeKey ,:rangeKey)").withValueMap((Map)new ValueMap().withString(":partitionKey", pKey).withString(":rangeKey", rkey)).withConsistentRead(true);
        ItemCollection query = table.query(querySpec);
        IteratorSupport iterator = query.iterator();
        Iterable iterable = () -> DynamodbEventRepository.lambda$getAllChildByType$5((Iterator)iterator);
        List items = StreamSupport.stream(iterable.spliterator(), false).map(attr -> (ChildEntity)GsonCodec.decode((Class)childType, (String)attr.getString(jsonColumn))).filter(i -> EventRepoUtil.onFilter((Object)i, (Map)paging.getParams())).collect(Collectors.toList());
        return EventRepoUtil.onPageable(items, (Query.PagingRequest)paging);
    }

    public <T1 extends ChildEntity<T>> ResultSet<T1> getAllChildByType(Class<T> rootType, String id, Class<T1> childType, Collection<String> tenantId, Query.PagingRequest paging) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public ResultSet<Event<T>> getEventsByRootId(Class<T> rootType, String rootId, String tenantId, Query.PagingRequest paging) {
        String trn = this.resourceHelper.getFQTrn(RootEntity.makeTRN(rootType, (String)this.version, (String)rootId, (String)tenantId) + "/events");
        Table table = this.dynamodb.getTable(this.tableName);
        QuerySpec querySpec = new QuerySpec().withKeyConditionExpression("partitionKey = :partitionKey AND rangeKey > :rangeKey").withFilterExpression("eventOwner = :eventOwner").withValueMap((Map)new ValueMap().withString(":partitionKey", trn).withString(":rangeKey", String.format("%019d", 0)).withString(":eventOwner", rootType.getSimpleName())).withConsistentRead(true).withScanIndexForward(Boolean.FALSE.booleanValue());
        ItemCollection query = table.query(querySpec);
        IteratorSupport iterator = query.iterator();
        Iterable iterable = () -> DynamodbEventRepository.lambda$getEventsByRootId$8((Iterator)iterator);
        List items = StreamSupport.stream(iterable.spliterator(), false).map(attr -> GsonCodec.decode((String)attr.getString(jsonColumn))).filter(i -> EventRepoUtil.onFilter((Object)i, (Map)paging.getParams())).collect(Collectors.toList());
        return EventRepoUtil.onPageable(items, (Query.PagingRequest)paging);
    }

    public <C extends ChildEntity<T>> ResultSet<Event<C>> getEventsByChildId(Class<T> rootType, String id, Class<C> childType, String childId, String tenantId, Query.PagingRequest paging) {
        String trn = this.resourceHelper.getFQTrn(RootEntity.makeTRN(rootType, (String)this.version, (String)id, (String)tenantId) + "/events");
        if (!EntityIdHelper.isTechnicalId((String)childId)) {
            childId = ((ChildEntity)this.getChildById(rootType, id, childType, childId, tenantId).get()).id();
        }
        Table table = this.dynamodb.getTable(this.tableName);
        QuerySpec querySpec = new QuerySpec().withKeyConditionExpression("partitionKey = :partitionKey AND rangeKey > :rangeKey").withFilterExpression("eventOwner = :eventOwner AND ownerId = :ownerId").withValueMap((Map)new ValueMap().withString(":partitionKey", trn).withString(":rangeKey", String.format("%019d", 0)).withString(":ownerId", childId).withString(":eventOwner", childType.getSimpleName())).withConsistentRead(true).withScanIndexForward(Boolean.FALSE.booleanValue());
        ItemCollection query = table.query(querySpec);
        IteratorSupport iterator = query.iterator();
        Iterable iterable = () -> DynamodbEventRepository.lambda$getEventsByChildId$11((Iterator)iterator);
        List items = StreamSupport.stream(iterable.spliterator(), false).map(attr -> GsonCodec.decode((String)attr.getString(jsonColumn))).filter(i -> EventRepoUtil.onFilter((Object)i, (Map)paging.getParams())).collect(Collectors.toList());
        return EventRepoUtil.onPageable(items, (Query.PagingRequest)paging);
    }

    protected void updateCheckpoint(EntityCheckpoint checkpoint) {
        String partitionKey = this.resourceHelper.getFQTrn(checkpoint.getRootTrn());
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put(partitionKeyColumn, new AttributeValue(partitionKey));
        item.put(rangeKeyColumn, new AttributeValue(EntityCheckpoint.class.getSimpleName()));
        item.put(jsonColumn, new AttributeValue(GsonCodec.encode((Object)checkpoint)));
        Put createEntity = new Put().withTableName(this.tableName).withItem(item).withReturnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure.ALL_OLD);
        this.txContext.get().add(new TransactWriteItem().withPut(createEntity));
    }

    public boolean isIdExist(String id, String tenantId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static /* synthetic */ Iterator lambda$getEventsByChildId$11(Iterator iterator) {
        return iterator;
    }

    private static /* synthetic */ Iterator lambda$getEventsByRootId$8(Iterator iterator) {
        return iterator;
    }

    private static /* synthetic */ Iterator lambda$getAllChildByType$5(Iterator iterator) {
        return iterator;
    }

    private static /* synthetic */ Iterator lambda$getAllByRootType$2(Iterator iterator) {
        return iterator;
    }
}

