/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.repo;

import com.cloudimpl.outstack.common.GsonCodec;
import com.cloudimpl.outstack.core.ComponentProvider;
import com.cloudimpl.outstack.runtime.EntityCheckpoint;
import com.cloudimpl.outstack.runtime.EntityIdHelper;
import com.cloudimpl.outstack.runtime.EventRepositoy;
import com.cloudimpl.outstack.runtime.ResourceHelper;
import com.cloudimpl.outstack.runtime.ResultSet;
import com.cloudimpl.outstack.runtime.domainspec.ChildEntity;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.Query;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import com.cloudimpl.outstack.runtime.domainspec.TenantRequirement;
import com.cloudimpl.outstack.runtime.repo.EventRepoUtil;
import com.cloudimpl.outstack.spring.repo.PostgresRepositoryFactory;
import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PostgresEventRepository<T extends RootEntity>
extends EventRepositoy<T> {
    private final ComponentProvider.ProviderConfigs configs;
    private String entityTable;
    private String eventTable;
    private PostgresRepositoryFactory factory;
    private final String tableName;
    ThreadLocal<List<Function<Connection, Integer>>> txContext = ThreadLocal.withInitial(() -> new LinkedList());

    public PostgresEventRepository(PostgresRepositoryFactory factory, Class<T> rootType, ResourceHelper resourceHelper, ComponentProvider.ProviderConfigs configs) {
        super(rootType, resourceHelper);
        this.factory = factory;
        this.configs = configs;
        this.tableName = (String)this.configs.getOption(rootType.getSimpleName() + "Table").or(() -> this.configs.getOption("defaultTable")).get();
        System.out.println("table name " + this.tableName + " pick for root type: " + rootType.getSimpleName());
        Function<Connection, Integer> createEntityTable = conn -> factory.createEntityTable((Connection)conn, this.tableName);
        factory.execute(Collections.singletonList(createEntityTable));
        Function<Connection, Integer> createEventTable = conn -> factory.createEventTable((Connection)conn, this.tableName);
        factory.execute(Collections.singletonList(createEventTable));
    }

    protected void startTransaction() {
        List<Function<Connection, Integer>> list = this.txContext.get();
        list.clear();
    }

    protected void endTransaction() {
        this.factory.execute(this.txContext.get());
    }

    protected void saveRootEntityBrnIfNotExist(RootEntity e) {
        String tenantId = e.getTenantId() != null ? e.getTenantId() : "nonTenant";
        String rn = this.resourceHelper.getFQBrn(e.getBRN());
        Function<Connection, Integer> func = conn -> this.factory.insertEntity((Connection)conn, this.tableName, tenantId, rn, e.getClass().getSimpleName(), e.id(), e.getClass().getSimpleName(), e.id(), GsonCodec.encode((Object)e), e.getMeta().getLastSeq());
        this.txContext.get().add(func);
    }

    protected void saveRootEntityTrnIfNotExist(RootEntity e) {
    }

    protected void saveRootEntityBrnIfExist(long lastSeq, RootEntity e) {
        String tenantId = e.getTenantId() != null ? e.getTenantId() : "nonTenant";
        String rn = this.resourceHelper.getFQBrn(e.getBRN());
        Function<Connection, Integer> func = conn -> this.factory.updateEntity((Connection)conn, this.tableName, tenantId, rn, e.getClass().getSimpleName(), e.id(), GsonCodec.encode((Object)e), lastSeq, e.getMeta().getLastSeq());
        this.txContext.get().add(func);
    }

    protected void saveRootEntityTrnIfExist(long lastSeq, RootEntity e) {
    }

    protected void saveChildEntityBrnIfNotExist(ChildEntity e) {
        String tenantId = e.getTenantId() != null ? e.getTenantId() : "nonTenant";
        String rn = this.resourceHelper.getFQBrn(e.getBRN());
        Function<Connection, Integer> func = conn -> this.factory.insertEntity((Connection)conn, this.tableName, tenantId, rn, e.rootType().getSimpleName(), e.rootId(), e.getClass().getSimpleName(), e.id(), GsonCodec.encode((Object)e), e.getMeta().getLastSeq());
        this.txContext.get().add(func);
    }

    protected void saveChildEntityTrnIfNotExist(ChildEntity e) {
    }

    protected void saveChildEntityBrnIfExist(long lastSeq, ChildEntity e) {
        String tenantId = e.getTenantId() != null ? e.getTenantId() : "nonTenant";
        String rn = this.resourceHelper.getFQBrn(e.getBRN());
        Function<Connection, Integer> func = conn -> this.factory.updateEntity((Connection)conn, this.tableName, tenantId, rn, e.getClass().getSimpleName(), e.id(), GsonCodec.encode((Object)e), lastSeq, e.getMeta().getLastSeq());
        this.txContext.get().add(func);
    }

    protected void saveChildEntityTrnIfExist(long lastSeq, ChildEntity e) {
    }

    protected void deleteRootEntityBrnById(RootEntity e, boolean deleteOnlyEntity) {
        String tenantId = e.getTenantId() != null ? e.getTenantId() : "nonTenant";
        String rn = this.resourceHelper.getFQBrn(RootEntity.makeRN((Class)this.rootType, (String)this.version, (String)e.entityId(), (String)e.getTenantId()));
        Function<Connection, Integer> func = conn -> this.factory.deleteEntity((Connection)conn, this.tableName, tenantId, rn, e.id());
        this.txContext.get().add(func);
        if (!deleteOnlyEntity) {
            func = conn -> this.factory.deleteChildEntityByRootId((Connection)conn, this.tableName, tenantId, e.getClass().getSimpleName(), e.id());
            this.txContext.get().add(func);
            func = conn -> this.factory.deleteEventsByRootId((Connection)conn, this.tableName + "Events", tenantId, e.id());
            this.txContext.get().add(func);
        }
    }

    protected void deleteRootEntityTrnById(Class<T> rootType, String id, String tenantId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected <C extends ChildEntity<T>> void deleteChildEntityBrnById(ChildEntity e, boolean deleteOnlyEntity) {
        String tenantId = e.getTenantId() != null ? e.getTenantId() : "nonTenant";
        String rn = this.resourceHelper.getFQBrn(ChildEntity.makeRN((Class)e.rootType(), (String)this.version, (String)e.rootId(), e.getClass(), (String)e.entityId(), (String)e.getTenantId()));
        String trn = this.resourceHelper.getFQTrn(RootEntity.makeTRN((Class)e.rootType(), (String)this.version, (String)e.rootId(), (String)e.getTenantId()));
        Function<Connection, Integer> func = conn -> this.factory.deleteEntity((Connection)conn, this.tableName, tenantId, rn, e.id());
        this.txContext.get().add(func);
        if (!deleteOnlyEntity) {
            func = conn -> this.factory.deleteEventsByTrn((Connection)conn, this.tableName + "Events", tenantId, trn, e.getClass().getSimpleName(), e.id());
            this.txContext.get().add(func);
        }
    }

    protected <C extends ChildEntity<T>> void deleteChildEntityTrnById(Class<T> rootType, String id, Class<C> childType, String childId, String tenantId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected Optional<EntityCheckpoint> _getCheckpoint(String rootTrn) {
        String partitionKey = this.resourceHelper.getFQTrn(rootTrn) + ":checkpoint";
        Function<Connection, Optional> fn = conn -> this.factory.getEntityByBrn((Connection)conn, this.tableName, partitionKey, "nonTenant");
        Optional out = this.factory.executeQuery(fn);
        return out.map(s -> (EntityCheckpoint)GsonCodec.decode(EntityCheckpoint.class, (String)s)).or(() -> Optional.of(new EntityCheckpoint(rootTrn).setSeq(0L)));
    }

    protected void addEvent(Event event) {
        String trn = this.resourceHelper.getFQTrn(event.getRootEntityTRN());
        Function<Connection, Integer> func = conn -> this.factory.insertEvent((Connection)conn, this.tableName + "Events", event.tenantId() == null ? "nonTenant" : event.tenantId(), trn, event.getOwner().getSimpleName(), event.id(), event.getClass().getSimpleName(), event.getSeqNum(), GsonCodec.encodeWithType((Object)event));
        this.txContext.get().add(func);
    }

    private String getRootBrn(Class<T> rootType, String tenantId) {
        String trn = null;
        TenantRequirement tenantReq = Entity.checkTenantRequirement(rootType);
        switch (tenantReq) {
            case REQUIRED: {
                trn = this.resourcePrefix("brn") + ":tenant/" + tenantId + "/" + this.version + "/" + rootType.getSimpleName();
                break;
            }
            case OPTIONAL: {
                if (tenantId != null) {
                    trn = this.resourcePrefix("brn") + ":tenant/" + tenantId + "/" + this.version + "/" + rootType.getSimpleName();
                    break;
                }
                trn = this.resourcePrefix("brn") + ":" + this.version + "/" + rootType.getSimpleName();
                break;
            }
            default: {
                trn = this.resourcePrefix("brn") + ":" + this.version + "/" + rootType.getSimpleName();
            }
        }
        return trn;
    }

    private <C extends ChildEntity<T>> String getChildBrn(Class<T> rootType, String id, Class<C> childType, String tenantId) {
        EntityIdHelper.validateTechnicalId((String)id);
        String trn = null;
        TenantRequirement tenantReq = Entity.checkTenantRequirement(rootType);
        switch (tenantReq) {
            case REQUIRED: {
                trn = this.resourcePrefix("brn") + ":tenant/" + tenantId + "/" + this.version + "/" + rootType.getSimpleName() + "/" + id + "/" + childType.getSimpleName() + "/";
                break;
            }
            case OPTIONAL: {
                if (tenantId != null) {
                    trn = this.resourcePrefix("brn") + ":tenant/" + tenantId + "/" + this.version + "/" + rootType.getSimpleName() + "/" + id + "/" + childType.getSimpleName() + "/";
                    break;
                }
                trn = this.resourcePrefix("brn") + ":" + this.version + "/" + rootType.getSimpleName() + "/" + id + "/" + childType.getSimpleName() + "/";
                break;
            }
            default: {
                trn = this.resourcePrefix("brn") + ":" + this.version + "/" + rootType.getSimpleName() + "/" + id + "/" + childType.getSimpleName() + "/";
            }
        }
        return trn;
    }

    public ResultSet<T> getAllByRootType(Class<T> rootType, String tenantId, Query.PagingRequest paging) {
        String t = tenantId != null ? tenantId : "nonTenant";
        Function<Connection, ResultSet> fn = conn -> this.factory.getRootEntityByType((Connection)conn, this.tableName, rootType.getSimpleName(), Collections.singletonList(t), paging.getSearchFilter(), paging.getOrderBy(), paging.pageNum(), paging.pageSize());
        ResultSet rs = this.factory.executeQuery(fn);
        List items = rs.getItems().stream().map(s -> (RootEntity)GsonCodec.decode((Class)rootType, (String)s)).collect(Collectors.toList());
        if (paging.getOrderBy() == null) {
            items = items.stream().filter(i -> EventRepoUtil.onFilter((Object)i, (Map)paging.getParams())).collect(Collectors.toList());
            return EventRepoUtil.onPageable(items, (Query.PagingRequest)paging);
        }
        return new ResultSet(rs.getTotalItems(), rs.getTotalPages(), rs.getCurrentPage(), items);
    }

    public ResultSet<T> getAllByRootType(Class<T> rootType, Collection<String> tenantIds, Query.PagingRequest paging) {
        List tenantIdList = tenantIds.stream().map(t -> t == null ? "nonTenant" : t).collect(Collectors.toList());
        Function<Connection, ResultSet> fn = conn -> this.factory.getRootEntityByType((Connection)conn, this.tableName, rootType.getSimpleName(), tenantIdList, paging.getSearchFilter(), paging.getOrderBy(), paging.pageNum(), paging.pageSize());
        ResultSet rs = this.factory.executeQuery(fn);
        List items = rs.getItems().stream().map(s -> (RootEntity)GsonCodec.decode((Class)rootType, (String)s)).collect(Collectors.toList());
        if (paging.getOrderBy() == null) {
            items = items.stream().filter(i -> EventRepoUtil.onFilter((Object)i, (Map)paging.getParams())).collect(Collectors.toList());
            return EventRepoUtil.onPageable(items, (Query.PagingRequest)paging);
        }
        return new ResultSet(rs.getTotalItems(), rs.getTotalPages(), rs.getCurrentPage(), items);
    }

    public Optional<T> getRootById(Class<T> rootType, String id, String tenantId) {
        Function<Connection, Optional> fn;
        String t;
        String string = t = tenantId != null ? tenantId : "nonTenant";
        if (EntityIdHelper.isTechnicalId((String)id)) {
            fn = conn -> this.factory.getEntityByTrn((Connection)conn, this.tableName, rootType.getSimpleName(), id, t);
        } else {
            String brn = this.resourceHelper.getFQBrn(RootEntity.makeRN(rootType, (String)this.version, (String)id, (String)tenantId));
            fn = conn -> this.factory.getEntityByBrn((Connection)conn, this.tableName, brn, t);
        }
        Optional out = this.factory.executeQuery(fn);
        return out.map(s -> (RootEntity)GsonCodec.decode((Class)rootType, (String)s));
    }

    public <C extends ChildEntity<T>> Optional<C> getChildById(Class<T> rootType, String id, Class<C> childType, String childId, String tenantId) {
        Function<Connection, Optional> fn;
        String t = tenantId != null ? tenantId : "nonTenant";
        EntityIdHelper.validateTechnicalId((String)id);
        if (EntityIdHelper.isTechnicalId((String)childId)) {
            fn = conn -> this.factory.getEntityByTrn((Connection)conn, this.tableName, childType.getSimpleName(), childId, t);
        } else {
            String brn = this.resourceHelper.getFQBrn(ChildEntity.makeRN(rootType, (String)this.version, (String)id, childType, (String)childId, (String)tenantId));
            fn = conn -> this.factory.getEntityByBrn((Connection)conn, this.tableName, brn, t);
        }
        Optional out = this.factory.executeQuery(fn);
        return out.map(s -> (ChildEntity)GsonCodec.decode((Class)childType, (String)s));
    }

    public <C extends ChildEntity<T>> ResultSet<C> getAllChildByType(Class<T> rootType, String id, Class<C> childType, String tenantId, Query.PagingRequest paging) {
        EntityIdHelper.validateTechnicalId((String)id);
        String t = tenantId != null ? tenantId : "nonTenant";
        Function<Connection, ResultSet> fn = conn -> this.factory.getChildEntityByType((Connection)conn, this.tableName, rootType.getSimpleName(), id, childType.getSimpleName(), Collections.singletonList(t), paging.getSearchFilter(), paging.getOrderBy(), paging.pageNum(), paging.pageSize());
        ResultSet rs = this.factory.executeQuery(fn);
        List items = rs.getItems().stream().map(s -> (ChildEntity)GsonCodec.decode((Class)childType, (String)s)).collect(Collectors.toList());
        if (paging.getOrderBy() == null) {
            items = items.stream().filter(i -> EventRepoUtil.onFilter((Object)i, (Map)paging.getParams())).collect(Collectors.toList());
            return EventRepoUtil.onPageable(items, (Query.PagingRequest)paging);
        }
        return new ResultSet(rs.getTotalItems(), rs.getTotalPages(), rs.getCurrentPage(), items);
    }

    public <C extends ChildEntity<T>> ResultSet<C> getAllChildByType(Class<T> rootType, String id, Class<C> childType, Collection<String> tenantIds, Query.PagingRequest paging) {
        EntityIdHelper.validateTechnicalId((String)id);
        List tenantIdList = tenantIds.stream().map(t -> t == null ? "nonTenant" : t).collect(Collectors.toList());
        Function<Connection, ResultSet> fn = conn -> this.factory.getChildEntityByType((Connection)conn, this.tableName, rootType.getSimpleName(), id, childType.getSimpleName(), tenantIdList, paging.getSearchFilter(), paging.getOrderBy(), paging.pageNum(), paging.pageSize());
        ResultSet rs = this.factory.executeQuery(fn);
        List items = rs.getItems().stream().map(s -> (ChildEntity)GsonCodec.decode((Class)childType, (String)s)).collect(Collectors.toList());
        if (paging.getOrderBy() == null) {
            items = items.stream().filter(i -> EventRepoUtil.onFilter((Object)i, (Map)paging.getParams())).collect(Collectors.toList());
            return EventRepoUtil.onPageable(items, (Query.PagingRequest)paging);
        }
        return new ResultSet(rs.getTotalItems(), rs.getTotalPages(), rs.getCurrentPage(), items);
    }

    public ResultSet<Event<T>> getEventsByRootId(Class<T> rootType, String rootId, String tenantId, Query.PagingRequest paging) {
        String t = tenantId != null ? tenantId : "nonTenant";
        String trn = this.resourceHelper.getFQTrn(RootEntity.makeTRN(rootType, (String)this.version, (String)rootId, (String)tenantId));
        Function<Connection, Collection> fn = conn -> this.factory.getEvents((Connection)conn, this.tableName + "Events", t, trn, this.rootType.getSimpleName(), rootId, Long.MAX_VALUE);
        List items = this.factory.executeQuery(fn).stream().map(s -> GsonCodec.decode((String)s)).filter(i -> EventRepoUtil.onFilter((Object)i, (Map)paging.getParams())).collect(Collectors.toList());
        return EventRepoUtil.onPageable(items, (Query.PagingRequest)paging);
    }

    public <C extends ChildEntity<T>> ResultSet<Event<C>> getEventsByChildId(Class<T> rootType, String id, Class<C> childType, String childId, String tenantId, Query.PagingRequest paging) {
        String t;
        EntityIdHelper.validateTechnicalId((String)id);
        String string = t = tenantId != null ? tenantId : "nonTenant";
        if (!EntityIdHelper.isTechnicalId((String)childId)) {
            childId = ((ChildEntity)this.getChildById(rootType, id, childType, childId, tenantId).get()).id();
        }
        String trn = this.resourceHelper.getFQTrn(RootEntity.makeTRN(rootType, (String)this.version, (String)id, (String)tenantId));
        String childTid = childId;
        Function<Connection, Collection> fn = conn -> this.factory.getEvents((Connection)conn, this.tableName + "Events", t, trn, childType.getSimpleName(), childTid, Long.MAX_VALUE);
        List items = this.factory.executeQuery(fn).stream().map(s -> GsonCodec.decode((String)s)).filter(i -> EventRepoUtil.onFilter((Object)i, (Map)paging.getParams())).collect(Collectors.toList());
        return EventRepoUtil.onPageable(items, (Query.PagingRequest)paging);
    }

    protected void updateCheckpoint(EntityCheckpoint checkpoint) {
        String partitionKey = this.resourceHelper.getFQTrn(checkpoint.getRootTrn()) + ":checkpoint";
        Function<Connection, Integer> func = conn -> this.factory.insertCheckpoint((Connection)conn, this.tableName, "nonTenant", partitionKey, EntityCheckpoint.class.getSimpleName(), "-", GsonCodec.encode((Object)checkpoint), checkpoint.getSeq());
        this.txContext.get().add(func);
    }

    public boolean isIdExist(String id, String tenantId) {
        EntityIdHelper.validateTechnicalId((String)id);
        Function<Connection, Boolean> func = conn -> this.factory.isIdExist((Connection)conn, this.tableName, id, tenantId == null ? "nonTenant" : tenantId);
        return this.factory.executeQuery(func);
    }
}

