/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.repo;

import com.cloudimpl.rstack.dsl.restql.BinNode;
import com.cloudimpl.rstack.dsl.restql.ConstArrayNode;
import com.cloudimpl.rstack.dsl.restql.ConstBooleanNode;
import com.cloudimpl.rstack.dsl.restql.ConstNode;
import com.cloudimpl.rstack.dsl.restql.ConstNumberNode;
import com.cloudimpl.rstack.dsl.restql.ConstStringNode;
import com.cloudimpl.rstack.dsl.restql.OrderByExpNode;
import com.cloudimpl.rstack.dsl.restql.OrderByNode;
import com.cloudimpl.rstack.dsl.restql.RelNode;
import com.cloudimpl.rstack.dsl.restql.RestQLNode;
import com.google.gson.JsonObject;
import java.util.stream.Collectors;

public class PostgresSqlNode
implements RestQLNode {
    public String eval(RestQLNode node) {
        if (node instanceof ConstArrayNode) {
            return ((ConstArrayNode)ConstArrayNode.class.cast(node)).getVals().toString();
        }
        if (node instanceof ConstStringNode) {
            return String.valueOf(((ConstStringNode)ConstStringNode.class.cast(node)).getVal());
        }
        if (node instanceof ConstNumberNode) {
            return String.valueOf(((ConstNumberNode)ConstNumberNode.class.cast(node)).getVal());
        }
        if (node instanceof ConstBooleanNode) {
            return String.valueOf(((ConstBooleanNode)ConstBooleanNode.class.cast(node)).getVal());
        }
        if (node instanceof RelNode) {
            RelNode rel = (RelNode)RelNode.class.cast(node);
            return PostgresSqlNode.castToType(PostgresSqlNode.convertToJsonField(rel.getFieldName()), rel.getConstNode()) + (rel.getOp() == RelNode.Op.LIKE ? " ILIKE " : rel.getOp().getOp()) + (String)rel.getConstNode().eval((RestQLNode)this);
        }
        if (node instanceof BinNode) {
            BinNode binNode = (BinNode)BinNode.class.cast(node);
            return "(" + binNode.getLeft().eval((RestQLNode)this) + binNode.getOp().getOp() + binNode.getRight().eval((RestQLNode)this) + ")";
        }
        if (node instanceof OrderByNode) {
            OrderByNode orderBy = (OrderByNode)OrderByNode.class.cast(node);
            return PostgresSqlNode.convertToJsonField(orderBy.getFieldName()) + " " + orderBy.getOrder();
        }
        if (node instanceof OrderByExpNode) {
            OrderByExpNode expNode = (OrderByExpNode)OrderByExpNode.class.cast(node);
            return expNode.getOrderByList().stream().map(i -> (String)i.eval((RestQLNode)this)).collect(Collectors.joining(","));
        }
        throw new RuntimeException("unknown node :" + node.getClass().getName());
    }

    public JsonObject toJson() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static String convertToJsonField(String field) {
        String[] fields = field.split("\\.");
        if (fields.length == 1) {
            return "json->>'" + field + "'";
        }
        if (fields.length == 2) {
            return "json->'" + fields[0] + "'->>'" + fields[1] + "'";
        }
        throw new RuntimeException("invalid field format");
    }

    public static String castToType(String fieldName, ConstNode constNode) {
        if (constNode instanceof ConstNumberNode) {
            return "(" + fieldName + ")::numeric";
        }
        if (constNode instanceof ConstBooleanNode) {
            return "(" + fieldName + ")::bool";
        }
        return fieldName;
    }
}

