/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security;

import com.cloudimpl.outstack.spring.security.Auth2Util;
import com.cloudimpl.outstack.spring.security.AuthenticationMeta;
import com.cloudimpl.outstack.spring.security.PlatformAuthenticationToken;
import java.util.Base64;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.authentication.ServerHttpBasicAuthenticationConverter;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class BasicLoginAuthenticationConverterEx
extends ServerHttpBasicAuthenticationConverter {
    private final String usernameParameter = "username";
    private final String passwordParameter = "password";
    private final String authorizationKeyParameter = "authKey";

    public Mono<Authentication> apply(ServerWebExchange exchange) {
        if (exchange.getResponse().getHeaders().getFirst("Access-Control-Allow-Origin") == null) {
            exchange.getResponse().getHeaders().add("Access-Control-Allow-Origin", "*");
            exchange.getResponse().getHeaders().add("Access-Control-Allow-Headers", "*");
            exchange.getResponse().getHeaders().add("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE");
        }
        ServerHttpRequest request = exchange.getRequest();
        String authorization = request.getHeaders().getFirst("Authorization");
        String context = request.getHeaders().getFirst("X-TokenContext");
        if (!StringUtils.startsWithIgnoreCase((String)authorization, (String)"basic ")) {
            return Mono.empty();
        }
        String credentials = authorization.length() <= "Basic ".length() ? "" : authorization.substring("Basic ".length(), authorization.length());
        String decoded = new String(this.base64Decode(credentials));
        String[] parts = decoded.split(":", 2);
        if (parts.length != 2) {
            return Mono.empty();
        }
        PlatformAuthenticationToken.TokenFlow flow = Auth2Util.createFlow(exchange);
        return Mono.just((Object)new UsernamePasswordAuthenticationToken((Object)parts[0], (Object)parts[1])).doOnNext(token -> token.setDetails((Object)new AuthenticationMeta(flow, null, context, Auth2Util.getGrantType(flow, exchange), Auth2Util.getClientMeta(exchange)))).cast(Authentication.class);
    }

    private byte[] base64Decode(String value) {
        try {
            return Base64.getDecoder().decode(value);
        }
        catch (Exception ex) {
            return new byte[0];
        }
    }
}

