/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security;

import com.cloudimpl.outstack.spring.security.Auth2Util;
import com.cloudimpl.outstack.spring.security.AuthenticationMeta;
import com.cloudimpl.outstack.spring.security.AuthenticationProvider;
import com.cloudimpl.outstack.spring.security.AuthorizationProvider;
import com.cloudimpl.outstack.spring.security.PlatformAuthenticationManager;
import com.cloudimpl.outstack.spring.security.PlatformAuthenticationToken;
import com.cloudimpl.outstack.spring.security.TokenProvider;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.server.resource.BearerTokenError;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component(value="Basic")
public class BasicTokenAuthenticationManager
extends PlatformAuthenticationManager {
    private static final Logger log = LoggerFactory.getLogger(BasicTokenAuthenticationManager.class);

    public BasicTokenAuthenticationManager(@Autowired(required=false) AuthenticationProvider authenticationProvider, @Autowired(required=false) AuthorizationProvider authorizationProvider, @Autowired(required=false) TokenProvider tokenProvider) {
        super(authenticationProvider, authorizationProvider, tokenProvider);
    }

    @Override
    protected Mono<PlatformAuthenticationToken> convertToPlatformToken(Authentication autentication) {
        return Mono.justOrEmpty((Object)autentication).filter(a -> a instanceof UsernamePasswordAuthenticationToken).cast(UsernamePasswordAuthenticationToken.class).doOnNext(a -> Auth2Util.validateAuthentcationMeta(a.getDetails())).map(a -> new PlatformAuthenticationToken((AuthenticationMeta)a.getDetails(), (String)a.getPrincipal(), Collections.EMPTY_LIST, null)).onErrorMap(JwtException.class, this::onError);
    }

    private OAuth2AuthenticationException onError(JwtException e) {
        log.info("Invalid Token", (Throwable)e);
        OAuth2Error invalidRequest = BasicTokenAuthenticationManager.invalidToken();
        return new OAuth2AuthenticationException(invalidRequest, e.getMessage());
    }

    private static OAuth2Error invalidToken() {
        return new BearerTokenError("invalid_token", HttpStatus.UNAUTHORIZED, "Invalid Access Token", "https://tools.ietf.org/html/rfc6750#section-3.1");
    }
}

