/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security;

import com.cloudimpl.outstack.spring.security.Auth2Util;
import com.cloudimpl.outstack.spring.security.AuthenticationMeta;
import com.cloudimpl.outstack.spring.security.AuthenticationProvider;
import com.cloudimpl.outstack.spring.security.AuthorizationProvider;
import com.cloudimpl.outstack.spring.security.PlatformAuthenticationManager;
import com.cloudimpl.outstack.spring.security.PlatformAuthenticationToken;
import com.cloudimpl.outstack.spring.security.TokenProvider;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.BearerTokenError;
import reactor.core.publisher.Mono;

public class BearerTokenAuthenticationManager
extends PlatformAuthenticationManager {
    private static final Logger log = LoggerFactory.getLogger(BearerTokenAuthenticationManager.class);
    private final ReactiveJwtDecoder jwtDecoder;

    public BearerTokenAuthenticationManager(ReactiveJwtDecoder jwtDecoder, AuthenticationProvider authenticationProvider, AuthorizationProvider authorizationProvider, TokenProvider tokenProvider) {
        super(authenticationProvider, authorizationProvider, tokenProvider);
        this.jwtDecoder = jwtDecoder;
    }

    @Override
    protected Mono<PlatformAuthenticationToken> convertToPlatformToken(Authentication authentication) {
        return Mono.justOrEmpty((Object)authentication).filter(a -> a instanceof BearerTokenAuthenticationToken).cast(BearerTokenAuthenticationToken.class).doOnNext(t -> Auth2Util.validateAuthentcationMeta(t.getDetails())).flatMap(this::decodeJwt).onErrorMap(JwtException.class, this::onError);
    }

    private Mono<PlatformAuthenticationToken> decodeJwt(BearerTokenAuthenticationToken token) {
        return Mono.just((Object)token).doOnNext(t -> log.info("token value={}", t)).map(t -> t.getToken()).flatMap(arg_0 -> ((ReactiveJwtDecoder)this.jwtDecoder).decode(arg_0)).map(jwt -> new PlatformAuthenticationToken((AuthenticationMeta)token.getDetails(), jwt.getSubject(), Collections.EMPTY_LIST, null).setJwtToken((Jwt)jwt));
    }

    private OAuth2AuthenticationException onError(JwtException e) {
        log.info("Invalid Token", (Throwable)e);
        OAuth2Error invalidRequest = BearerTokenAuthenticationManager.invalidToken();
        return new OAuth2AuthenticationException(invalidRequest, e.getMessage());
    }

    private static OAuth2Error invalidToken() {
        return new BearerTokenError("invalid_token", HttpStatus.UNAUTHORIZED, "Invalid Access Token", "https://tools.ietf.org/html/rfc6750#section-3.1");
    }
}

