/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security;

import com.cloudimpl.outstack.runtime.ValidationErrorException;
import java.util.Objects;

public enum GrantType {
    AUTHORIZATION_CODE,
    PASSWORD,
    REFRESH_TOKEN,
    TENANT_TOKEN,
    CUSTOM_TOKEN;


    public static GrantType from(String type) {
        Objects.requireNonNull(type, "grant type cannot be null");
        switch (type = type.toLowerCase()) {
            case "authorization_code": {
                return AUTHORIZATION_CODE;
            }
            case "password": {
                return PASSWORD;
            }
            case "refresh_token": {
                return REFRESH_TOKEN;
            }
            case "tenant_token": {
                return TENANT_TOKEN;
            }
            case "custom_token": {
                return CUSTOM_TOKEN;
            }
        }
        throw new ValidationErrorException("unknown grant type:" + type);
    }
}

