/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security;

import com.cloudimpl.outstack.spring.security.JwtKeyProvider;
import com.cloudimpl.outstack.spring.security.JwtOneTimeTokenBuilder;
import com.cloudimpl.outstack.spring.security.JwtToken;
import com.cloudimpl.outstack.spring.security.JwtTokenBuilder;
import com.cloudimpl.outstack.spring.security.PlatformAuthenticationException;
import com.cloudimpl.outstack.spring.security.TokenResponse;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.SignedJWT;
import java.security.PrivateKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class JwtTokenGenerator {
    @Value(value="${outstack.oauth.token.issuer:http://www.cloudimpl.com}")
    private String tokenIssuer;
    @Value(value="${outstack.oauth.token.access_token_lifetime:60}")
    private long access_token_lifetime;
    @Value(value="${outstack.oauth.token.refresh_token_lifetime:180}")
    private long refresh_token_lifetime;
    @Value(value="${outstack.apiContext}")
    private String apiContext;
    private final JWSSigner signer;
    public static JwtTokenGenerator instance;

    public JwtTokenGenerator(@Autowired(required=false) JwtKeyProvider keyProvider) {
        this.signer = keyProvider != null ? new RSASSASigner((PrivateKey)keyProvider.getPrivateKey()) : null;
        instance = this;
    }

    public JwtToken createAccessToken(JwtTokenBuilder builder) {
        builder.withIssuer(this.tokenIssuer);
        builder.withExpireTime(this.access_token_lifetime);
        return builder.build();
    }

    public JwtToken createRefreshToken(JwtTokenBuilder builder) {
        builder.withIssuer(this.tokenIssuer);
        builder.withExpireTime(this.refresh_token_lifetime);
        return builder.build();
    }

    public JwtToken createOneTimeToken(JwtOneTimeTokenBuilder builder, long expireTime) {
        builder.withClaim("@apiContext", this.apiContext);
        builder.withIssuer(this.tokenIssuer);
        builder.withExpireTime(expireTime);
        return builder.build();
    }

    public static JwtTokenGenerator instance() {
        return instance;
    }

    public String serializeToken(JwtToken token) {
        try {
            SignedJWT jwt = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.RS256).build(), token.getJwt());
            jwt.sign(this.signer);
            return jwt.serialize();
        }
        catch (JOSEException ex) {
            throw new PlatformAuthenticationException(ex.getMessage(), ex);
        }
    }

    public TokenResponse createTokenResponse(JwtToken accessToken, JwtToken refreshToken) {
        return new TokenResponse(this.serializeToken(accessToken), refreshToken == null ? null : this.serializeToken(refreshToken), "bearer", accessToken.getExpireTimeInSeconds());
    }
}

