/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security;

import com.cloudimpl.outstack.runtime.ValidationErrorException;
import com.cloudimpl.outstack.spring.security.AuthenticationMeta;
import com.cloudimpl.outstack.spring.security.AuthenticationProvider;
import com.cloudimpl.outstack.spring.security.AuthorizationProvider;
import com.cloudimpl.outstack.spring.security.PlatformAuthenticationException;
import com.cloudimpl.outstack.spring.security.PlatformAuthenticationToken;
import com.cloudimpl.outstack.spring.security.TokenProvider;
import com.cloudimpl.outstack.spring.security.TokenResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import reactor.core.publisher.Mono;

public abstract class PlatformAuthenticationManager
implements ReactiveAuthenticationManager {
    private final AuthenticationProvider authenticationProvider;
    private final AuthorizationProvider authorizationProvider;
    private final TokenProvider tokenProvider;

    public PlatformAuthenticationManager(@Autowired(required=false) AuthenticationProvider authenticationProvider, @Autowired(required=false) AuthorizationProvider authorizationProvider, @Autowired(required=false) TokenProvider tokenProvider) {
        this.authenticationProvider = authenticationProvider == null ? t -> Mono.error(() -> new RuntimeException("AuthenticationProvider not provisioned")) : authenticationProvider;
        this.authorizationProvider = authorizationProvider == null ? t -> Mono.error(() -> new PlatformAuthenticationException("AuthorizationProvider not provisioned", null)) : authorizationProvider;
        this.tokenProvider = tokenProvider == null ? t -> Mono.error(() -> new PlatformAuthenticationException("TokenProvider not provisioned", null)) : tokenProvider;
    }

    public Mono<Authentication> authenticate(Authentication authentication) {
        return this.convertToPlatformToken(authentication).doOnNext(pt -> pt.setSystemToken(authentication)).flatMap(this::onPlatformToken).cast(Authentication.class);
    }

    private Mono<PlatformAuthenticationToken> onPlatformToken(PlatformAuthenticationToken token) {
        AuthenticationMeta meta = token.getAuthMeta();
        if (meta == null) {
            throw new PlatformAuthenticationException("no meta data found in the platform token", null);
        }
        switch (meta.getTokenFlow()) {
            case AUTHENTICATION_FLOW: {
                return this.authenticationProvider.authenticate(token);
            }
            case AUTHORIZATION_FLOW: {
                return this.authorizationProvider.authenticate(token);
            }
            case TOKEN_FLOW: {
                return Mono.just((Object)((Object)token)).doOnNext(t -> this.validateTokenFlow((PlatformAuthenticationToken)((Object)t))).flatMap(t -> this.tokenProvider.authenticate((PlatformAuthenticationToken)((Object)t))).doOnNext(this::validateTokenResponse);
            }
        }
        return Mono.error(() -> new PlatformAuthenticationException("unknown token flow:" + meta.getTokenFlow(), null));
    }

    protected abstract Mono<PlatformAuthenticationToken> convertToPlatformToken(Authentication var1);

    private void validateTokenResponse(PlatformAuthenticationToken token) {
        if (token.getResponse() == null || !(token.getResponse() instanceof TokenResponse)) {
            throw new PlatformAuthenticationException("token response is null or invalid", null);
        }
    }

    private void validateTokenFlow(PlatformAuthenticationToken token) {
        switch (token.getAuthMeta().getGrantType()) {
            case AUTHORIZATION_CODE: {
                break;
            }
            case PASSWORD: {
                if (UsernamePasswordAuthenticationToken.class.isInstance(token.getSystemToken())) break;
                throw new ValidationErrorException("grant type does not match with token type");
            }
            case REFRESH_TOKEN: {
                if (BearerTokenAuthenticationToken.class.isInstance(token.getSystemToken())) break;
                throw new ValidationErrorException("grant type does not match with token type");
            }
            case CUSTOM_TOKEN: {
                if (BearerTokenAuthenticationToken.class.isInstance(token.getSystemToken())) break;
                throw new ValidationErrorException("grant type does not match with token type");
            }
        }
    }
}

