/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security;

import com.cloudimpl.outstack.spring.security.PlatformAuthenticationException;
import com.cloudimpl.outstack.spring.security.PlatformAuthenticationToken;
import com.cloudimpl.outstack.spring.security.RedirectionUrl;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.DefaultServerRedirectStrategy;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.savedrequest.ServerRequestCache;
import org.springframework.security.web.server.savedrequest.WebSessionServerRequestCache;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class PlatformAuthenticationSuccessHandler
implements ServerAuthenticationSuccessHandler {
    private ObjectMapper mapper = new ObjectMapper();
    private URI location = URI.create("/hello");
    private ServerRedirectStrategy redirectStrategy = new DefaultServerRedirectStrategy();
    private ServerRequestCache requestCache = new WebSessionServerRequestCache();

    public Mono<Void> onAuthenticationSuccess(WebFilterExchange wfe, Authentication a) {
        if (!(a instanceof PlatformAuthenticationToken)) {
            throw new PlatformAuthenticationException("invalid authentication token", null);
        }
        PlatformAuthenticationToken pToken = (PlatformAuthenticationToken)((Object)PlatformAuthenticationToken.class.cast(a));
        if (pToken.getResponse() == null) {
            return Mono.error((Throwable)new RuntimeException("token response is empty"));
        }
        if (pToken.getResponse() instanceof RedirectionUrl) {
            RedirectionUrl url = (RedirectionUrl)RedirectionUrl.class.cast(pToken.getResponse());
            ServerWebExchange exchange = wfe.getExchange();
            return this.requestCache.getRedirectUri(exchange).defaultIfEmpty((Object)URI.create(url.getUrl())).flatMap(location -> this.redirectStrategy.sendRedirect(exchange, location));
        }
        try {
            Mono buffer = Mono.just((Object)this.mapper.writeValueAsBytes(pToken.getResponse())).map(b -> wfe.getExchange().getResponse().bufferFactory().wrap(b));
            wfe.getExchange().getResponse().getHeaders().add("Content-Type", "application/json");
            wfe.getExchange().getResponse().setStatusCode(HttpStatus.OK);
            return wfe.getExchange().getResponse().writeWith((Publisher)buffer);
        }
        catch (JsonProcessingException ex) {
            Logger.getLogger(PlatformAuthenticationSuccessHandler.class.getName()).log(Level.SEVERE, null, ex);
            return Mono.error((Throwable)ex);
        }
    }
}

