/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security;

import com.cloudimpl.outstack.common.Pair;
import com.cloudimpl.outstack.runtime.domain.PolicyStatement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.security.core.GrantedAuthority;

public class PlatformGrantedAuthority
implements GrantedAuthority {
    private final Map<String, List<PolicyStatement>> denyPolicyStmts;
    private final Map<String, List<PolicyStatement>> allowPolicyStmts;

    public PlatformGrantedAuthority(Collection<PolicyStatement> denyPolicyStmts, Collection<PolicyStatement> allowPolicyStmts) {
        this.denyPolicyStmts = denyPolicyStmts.stream().flatMap(s -> s.getResources().stream().map(r -> new Pair((Object)r.getRootType(), s))).collect(Collectors.groupingBy(s -> (String)s.getKey(), Collectors.mapping(s -> (PolicyStatement)s.getValue(), Collectors.toList())));
        this.allowPolicyStmts = allowPolicyStmts.stream().flatMap(s -> s.getResources().stream().map(r -> new Pair((Object)r.getRootType(), s))).collect(Collectors.groupingBy(s -> (String)s.getKey(), Collectors.mapping(s -> (PolicyStatement)s.getValue(), Collectors.toList())));
    }

    public Optional<List<PolicyStatement>> getDenyStatmentByResourceName(String resourceName, String domainOwner, String domainContext) {
        return Optional.ofNullable(this.denyPolicyStmts.get("*")).or(() -> Optional.ofNullable(this.denyPolicyStmts.get(resourceName))).map(l -> l.stream().filter(s -> this.validate((PolicyStatement)s, domainOwner, domainContext)).collect(Collectors.toList()));
    }

    private boolean validate(PolicyStatement stmt, String domainOwner, String domainContext) {
        if (stmt.getDomainOwner().equals("*") && stmt.getDomainContext().equals("*")) {
            return true;
        }
        if (stmt.getDomainOwner().equals("*") && stmt.getDomainContext().equalsIgnoreCase(domainContext)) {
            return true;
        }
        if (stmt.getDomainContext().equals("*") && stmt.getDomainOwner().equalsIgnoreCase(domainOwner)) {
            return true;
        }
        return stmt.getDomainOwner().equalsIgnoreCase(domainOwner) && stmt.getDomainContext().equalsIgnoreCase(domainContext);
    }

    public Optional<List<PolicyStatement>> getAllowStatmentByResourceName(String resourceName) {
        return Optional.ofNullable(this.allowPolicyStmts.get("*")).or(() -> Optional.ofNullable(this.allowPolicyStmts.get(resourceName)));
    }

    public String getAuthority() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

