/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security;

import com.cloudimpl.outstack.runtime.domain.PolicyStatement;
import com.cloudimpl.outstack.runtime.domainspec.AuthInput;
import com.cloudimpl.outstack.runtime.iam.ActionDescriptor;
import com.cloudimpl.outstack.runtime.iam.ResourceDescriptor;
import com.cloudimpl.outstack.spring.security.PlatformAuthenticationException;
import com.cloudimpl.outstack.spring.security.PlatformAuthenticationToken;
import com.cloudimpl.outstack.spring.security.PlatformGrantedAuthority;
import com.cloudimpl.outstack.spring.security.PolicyEvaluationException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PolicyStatementValidator {
    private static final Logger log = LoggerFactory.getLogger(PolicyStatementValidator.class);
    @Value(value="${outstack.apiGateway.validatePolicy:true}")
    private boolean validatePolicy;

    public PlatformGrantedAuthority processPolicyStatementsForCommand(AuthInput input, PlatformAuthenticationToken token) {
        Optional<List<PolicyStatement>> allowStmts;
        PlatformGrantedAuthority grant = token.getAuthorities().stream().map(g -> (PlatformGrantedAuthority)PlatformGrantedAuthority.class.cast(g)).findAny().orElseThrow(() -> new PlatformAuthenticationException("no grant found to authenticate", null));
        if (!this.validatePolicy) {
            log.warn("policy validation has turned off, skipping");
            return grant;
        }
        Optional<List<PolicyStatement>> denyStmts = grant.getDenyStatmentByResourceName(input.getRootType(), input.getDomainOwner(), input.getDomainContext());
        if (denyStmts.isPresent()) {
            denyStmts.get().stream().map(denyStmt -> {
                denyStmt.getCmdActions().stream().filter(a -> a.isActionMatched(input.getAction())).findAny().ifPresent(a -> {
                    throw new PolicyEvaluationException("command action {0} is denied from policy statement {1}", AuthInput.verbose((AuthInput)input), a);
                });
                return denyStmt;
            }).forEachOrdered(denyStmt -> denyStmt.getResources().stream().filter(a -> a.isResourceMatched(input, token.getJwtToken().getClaims())).findAny().ifPresent(a -> {
                throw new PolicyEvaluationException("command resource {0} is denied from policy statement {1}", AuthInput.verbose((AuthInput)input), a);
            }));
        }
        if ((allowStmts = grant.getAllowStatmentByResourceName(input.getRootType())).isPresent()) {
            for (PolicyStatement allowStmt : allowStmts.get()) {
                ActionDescriptor actionDesc = allowStmt.getCmdActions().stream().filter(a -> a.isActionMatched(input.getAction())).findAny().orElse(null);
                if (actionDesc == null) {
                    log.info("command action false -> {} -> {}", (Object)AuthInput.verbose((AuthInput)input), (Object)allowStmt);
                    continue;
                }
                log.info("command action true -> {} -> {}", (Object)AuthInput.verbose((AuthInput)input), (Object)allowStmt);
                ResourceDescriptor resourceDesc = allowStmt.getResources().stream().filter(a -> a.isResourceMatched(input, token.getJwtToken().getClaims())).findAny().orElse(null);
                if (resourceDesc == null) {
                    log.info("command resource false -> {} -> {}", (Object)AuthInput.verbose((AuthInput)input), (Object)allowStmt);
                    continue;
                }
                log.info("command resource true -> {} -> {}", (Object)AuthInput.verbose((AuthInput)input), (Object)allowStmt);
                return grant;
            }
            throw new PolicyEvaluationException("command resource {0} access not allowed for action {1} , {2}", input.getRootType(), input.getAction(), AuthInput.verbose((AuthInput)input));
        }
        throw new PolicyEvaluationException("command resource {0} access not allowed for action {1} , {2}", input.getRootType(), input.getAction(), AuthInput.verbose((AuthInput)input));
    }

    public PlatformGrantedAuthority processPolicyStatementsForQuery(AuthInput input, PlatformAuthenticationToken token) {
        Optional<List<PolicyStatement>> allowStmts;
        PlatformGrantedAuthority grant = token.getAuthorities().stream().map(g -> (PlatformGrantedAuthority)PlatformGrantedAuthority.class.cast(g)).findAny().orElseThrow(() -> new PlatformAuthenticationException("no grant found to authenticate", null));
        if (!this.validatePolicy) {
            log.warn("policy validation has turned off, skipping");
            return grant;
        }
        Optional<List<PolicyStatement>> denyStmts = grant.getDenyStatmentByResourceName(input.getRootType(), input.getDomainOwner(), input.getDomainContext());
        if (denyStmts.isPresent()) {
            denyStmts.get().stream().map(denyStmt -> {
                denyStmt.getQueryActions().stream().filter(a -> a.isActionMatched(input.getAction())).findAny().ifPresent(a -> {
                    throw new PolicyEvaluationException("query action {0} is denied from policy statement {1}", AuthInput.verbose((AuthInput)input), a);
                });
                return denyStmt;
            }).forEachOrdered(denyStmt -> denyStmt.getResources().stream().filter(a -> a.isResourceMatched(input, token.getJwtToken().getClaims())).findAny().ifPresent(a -> {
                throw new PolicyEvaluationException("query resource {0} is denied from policy statement {1}", AuthInput.verbose((AuthInput)input), a);
            }));
        }
        if ((allowStmts = grant.getAllowStatmentByResourceName(input.getRootType())).isPresent()) {
            for (PolicyStatement allowStmt : allowStmts.get()) {
                ActionDescriptor actionDesc = allowStmt.getQueryActions().stream().filter(a -> a.isActionMatched(input.getAction())).findAny().orElse(null);
                if (actionDesc == null) {
                    log.info("query action false -> {} -> {}", (Object)AuthInput.verbose((AuthInput)input), (Object)allowStmt);
                    continue;
                }
                log.info("query action true -> {} -> {}", (Object)AuthInput.verbose((AuthInput)input), (Object)allowStmt);
                ResourceDescriptor resourceDesc = allowStmt.getResources().stream().filter(a -> a.isResourceMatched(input, token.getJwtToken().getClaims())).findAny().orElse(null);
                if (resourceDesc == null) {
                    log.info("query resource false -> {} -> {}", (Object)AuthInput.verbose((AuthInput)input), (Object)allowStmt);
                    continue;
                }
                log.info("query resource true -> {} -> {}", (Object)AuthInput.verbose((AuthInput)input), (Object)allowStmt);
                return grant;
            }
            throw new PolicyEvaluationException("query resource {0} access not allowed for action {1} , {2}", input.getRootType(), input.getAction(), AuthInput.verbose((AuthInput)input));
        }
        throw new PolicyEvaluationException("query resource {0} access not allowed for action {1}", input.getRootType(), input.getAction());
    }
}

