/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security;

import com.cloudimpl.outstack.spring.security.AuthenticationManagerResolver;
import com.cloudimpl.outstack.spring.security.BasicLoginAuthenticationConverterEx;
import com.cloudimpl.outstack.spring.security.BearerTokenServerAuthenticationEntryPoint;
import com.cloudimpl.outstack.spring.security.PlatformAuthenticationSuccessHandler;
import com.cloudimpl.outstack.spring.security.SecurityProperties;
import com.cloudimpl.outstack.spring.security.ServerBearerTokenAuthenticationConverterEx;
import com.cloudimpl.outstack.spring.security.ServerFormLoginAuthenticationConverterEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authentication.ReactiveAuthenticationManagerResolver;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authentication.AuthenticationWebFilter;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.security.web.server.authentication.ServerAuthenticationEntryPointFailureHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationFailureHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.web.server.WebFilter;

@Configuration
@EnableWebFluxSecurity
@EnableConfigurationProperties(value={SecurityProperties.class})
public class SecurityConfig {
    private static final String[] AUTH_WHITELIST = new String[]{"/v2/api-docs", "/favicon.ico", "/swagger-resources", "/swagger-resources/**", "/configuration/ui", "/configuration/**", "/configuration/security", "/swagger-ui.html", "/webjars/**", "/v3/api-docs/**", "/swagger-ui/**", "/swagger-ui/", "/swagger-ui"};
    @Autowired
    AuthenticationManagerResolver authenticationManagerResolver;

    public AuthenticationWebFilter authenticationFilter(ReactiveAuthenticationManager authManager, ServerAuthenticationConverter convertor, String ... urls) {
        AuthenticationWebFilter authenticationFilter = new AuthenticationWebFilter(authManager);
        authenticationFilter.setRequiresAuthenticationMatcher(ServerWebExchangeMatchers.pathMatchers((HttpMethod)HttpMethod.POST, (String[])urls));
        authenticationFilter.setAuthenticationFailureHandler((ServerAuthenticationFailureHandler)new ServerAuthenticationEntryPointFailureHandler((ServerAuthenticationEntryPoint)new BearerTokenServerAuthenticationEntryPoint()));
        authenticationFilter.setServerAuthenticationConverter(convertor);
        authenticationFilter.setAuthenticationSuccessHandler((ServerAuthenticationSuccessHandler)new PlatformAuthenticationSuccessHandler());
        return authenticationFilter;
    }

    @Bean
    SecurityWebFilterChain securityWebFilterChain(ServerHttpSecurity http, SecurityProperties securityProperties) {
        ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)http.csrf().disable().cors().and().authorizeExchange().pathMatchers(HttpMethod.OPTIONS)).permitAll().pathMatchers(new String[]{"/public/**"})).permitAll().pathMatchers(AUTH_WHITELIST)).permitAll().pathMatchers(new String[]{"/login/**", "/authorize"})).permitAll().anyExchange().authenticated().and().httpBasic().disable().formLogin().disable().addFilterAt((WebFilter)this.authenticationFilter(this.authenticationManagerResolver.getBasicTokenAuthentication(), (ServerAuthenticationConverter)new ServerFormLoginAuthenticationConverterEx(), "/login", "/token"), SecurityWebFiltersOrder.FORM_LOGIN).addFilterAt((WebFilter)this.authenticationFilter(this.authenticationManagerResolver.getBasicTokenAuthentication(), (ServerAuthenticationConverter)new BasicLoginAuthenticationConverterEx(), "/login", "/token"), SecurityWebFiltersOrder.HTTP_BASIC).oauth2ResourceServer(o -> o.authenticationManagerResolver((ReactiveAuthenticationManagerResolver)this.authenticationManagerResolver).bearerTokenConverter((ServerAuthenticationConverter)new ServerBearerTokenAuthenticationConverterEx(false))).addFilterBefore((WebFilter)this.authenticationFilter(this.authenticationManagerResolver.getBearerTokenAuthentication(), (ServerAuthenticationConverter)new ServerBearerTokenAuthenticationConverterEx(true), "/token"), SecurityWebFiltersOrder.AUTHENTICATION);
        return http.build();
    }
}

