/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security;

import com.cloudimpl.outstack.spring.security.Auth2Util;
import com.cloudimpl.outstack.spring.security.AuthenticationMeta;
import com.cloudimpl.outstack.spring.security.PlatformAuthenticationToken;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.web.server.ServerBearerTokenAuthenticationConverter;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ServerBearerTokenAuthenticationConverterEx
extends ServerBearerTokenAuthenticationConverter {
    private final boolean tokenEndpoint;

    public ServerBearerTokenAuthenticationConverterEx(boolean tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public Mono<Authentication> convert(ServerWebExchange exchange) {
        if (exchange.getResponse().getHeaders().getFirst("Access-Control-Allow-Origin") == null) {
            exchange.getResponse().getHeaders().add("Access-Control-Allow-Origin", "*");
            exchange.getResponse().getHeaders().add("Access-Control-Allow-Headers", "*");
            exchange.getResponse().getHeaders().add("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE");
        }
        if (exchange.getRequest().getMethod() == HttpMethod.OPTIONS) {
            return Mono.empty();
        }
        String context = exchange.getRequest().getHeaders().getFirst("X-TokenContext");
        AuthenticationMeta meta = Auth2Util.createAuthMeta(null, context, exchange);
        if (this.tokenEndpoint && meta.getTokenFlow() != PlatformAuthenticationToken.TokenFlow.TOKEN_FLOW) {
            return Mono.empty();
        }
        return super.convert(exchange).cast(BearerTokenAuthenticationToken.class).doOnNext(token -> token.setDetails((Object)meta)).cast(Authentication.class);
    }
}

