/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security;

import com.cloudimpl.outstack.runtime.domainspec.Command;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UserLoginRequest
extends Command {
    private final String userId;
    private final String password;
    private final Map<String, String> mapAttr;

    public UserLoginRequest(Builder builder) {
        super((Command.Builder)builder);
        this.userId = builder.userId;
        this.password = builder.password;
        this.mapAttr = Collections.unmodifiableMap(builder.mapAttr);
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    public Map<String, String> getMapAttr() {
        return this.mapAttr;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Command.Builder {
        private String userId;
        private String password;
        private Map<String, String> mapAttr = new HashMap<String, String>();

        public Builder withUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder withAttr(String key, String value) {
            this.mapAttr.put(key, value);
            return this;
        }

        public UserLoginRequest build() {
            return new UserLoginRequest(this);
        }
    }
}

