/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security.service;

import com.cloudimpl.outstack.common.CloudMessage;
import com.cloudimpl.outstack.common.RouterType;
import com.cloudimpl.outstack.core.CloudService;
import com.cloudimpl.outstack.core.ServiceRegistryReadOnly;
import com.cloudimpl.outstack.core.annon.CloudFunction;
import com.cloudimpl.outstack.core.annon.Router;
import com.cloudimpl.outstack.runtime.ResourceCache;
import com.cloudimpl.outstack.spring.security.PlatformAuthenticationException;
import com.cloudimpl.outstack.spring.security.service.AuthorizeKeyRequest;
import com.cloudimpl.outstack.spring.security.service.AuthorizeRequest;
import com.cloudimpl.outstack.spring.security.service.AuthorizeResponse;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@CloudFunction(name="AuthenticationService")
@Router(routerType=RouterType.SERVICE_ID)
public class AuthenticationService
implements Function<CloudMessage, Mono<? extends Object>> {
    private final ResourceCache<AuthorizeRequest> requestCache;
    private final ServiceRegistryReadOnly serviceRegistry;

    public AuthenticationService(ServiceRegistryReadOnly serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.requestCache = new ResourceCache(10000, Duration.ofMinutes(1L));
    }

    @Override
    public Mono<? extends Object> apply(CloudMessage t) {
        if (t.data() instanceof AuthorizeRequest) {
            return this.onAuthenticationRequest((AuthorizeRequest)t.data());
        }
        if (t.data() instanceof AuthorizeKeyRequest) {
            return this.onAuthKeyRequest((AuthorizeKeyRequest)t.data());
        }
        return Mono.empty();
    }

    private Mono<AuthorizeResponse> onAuthenticationRequest(AuthorizeRequest req) {
        CloudService service = (CloudService)this.serviceRegistry.findLocalByName("AuthenticationService").orElseThrow(() -> new PlatformAuthenticationException("auth service not found", null));
        String authKey = UUID.randomUUID().toString() + "," + service.id();
        this.requestCache.put(authKey, (Object)req);
        System.out.println("auth key generated" + authKey);
        return Mono.just((Object)new AuthorizeResponse(authKey));
    }

    private Mono<AuthorizeResponse> onAuthKeyRequest(AuthorizeKeyRequest req) {
        return Mono.justOrEmpty((Optional)this.requestCache.get(req.getKey()));
    }
}

