/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.service;

import com.cloudimpl.outstack.spring.component.SpringServiceDescriptor;
import com.cloudimpl.outstack.spring.service.ServiceDescriptorManager;
import com.cloudimpl.outstack.spring.service.ServiceDescriptorVersionManager;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public class ServiceDescriptorContextManager {
    private final Map<String, ServiceDescriptorVersionManager> appContexts = new ConcurrentHashMap<String, ServiceDescriptorVersionManager>();

    public void putCmdContext(String context, String version, SpringServiceDescriptor serviceDescriptor) {
        this.appContexts.computeIfAbsent(context, ctx -> new ServiceDescriptorVersionManager()).putCmd(serviceDescriptor);
    }

    public void putQueryContext(String context, String version, SpringServiceDescriptor serviceDescriptor) {
        this.appContexts.computeIfAbsent(context, ctx -> new ServiceDescriptorVersionManager()).putQuery(serviceDescriptor);
    }

    public Optional<ServiceDescriptorManager> getCmdServiceDescriptorManager(String context, String version) {
        return Optional.ofNullable(this.appContexts.get(context)).flatMap(ctx -> ctx.getVersionForCmd(version));
    }

    public Optional<ServiceDescriptorManager> getQueryServiceDescriptorManager(String context, String version) {
        return Optional.ofNullable(this.appContexts.get(context)).flatMap(ctx -> ctx.getVersionForQuery(version));
    }

    public ServiceDescriptorVersionManager getByContext(String context) {
        return this.appContexts.get(context);
    }
}

