/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.service;

import com.cloudimpl.outstack.common.Pair;
import com.cloudimpl.outstack.spring.component.SpringServiceDescriptor;
import com.cloudimpl.outstack.spring.service.ServiceDescriptorManager;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class ServiceDescriptorVersionManager {
    private final Map<String, ServiceDescriptorManager> mapCmd = new ConcurrentHashMap<String, ServiceDescriptorManager>();
    private final Map<String, ServiceDescriptorManager> mapQuery = new ConcurrentHashMap<String, ServiceDescriptorManager>();

    protected void putCmd(SpringServiceDescriptor serviceDesc) {
        ServiceDescriptorManager man = this.mapCmd.computeIfAbsent(serviceDesc.getVersion(), n -> new ServiceDescriptorManager());
        man.putByPlural(serviceDesc);
    }

    protected void putQuery(SpringServiceDescriptor serviceDesc) {
        ServiceDescriptorManager man = this.mapQuery.computeIfAbsent(serviceDesc.getVersion(), n -> new ServiceDescriptorManager());
        man.putByPlural(serviceDesc);
    }

    public Optional<ServiceDescriptorManager> getVersionForCmd(String version) {
        return Optional.ofNullable(this.mapCmd.get(version));
    }

    public Optional<ServiceDescriptorManager> getVersionForQuery(String version) {
        return Optional.ofNullable(this.mapQuery.get(version));
    }

    public Collection<Pair<String, ServiceDescriptorManager>> getCmdDescriptors() {
        return this.mapCmd.entrySet().stream().map(s -> new Pair((Object)((String)s.getKey()), (Object)((ServiceDescriptorManager)s.getValue()))).collect(Collectors.toList());
    }

    public Collection<Pair<String, ServiceDescriptorManager>> getQueryDescriptors() {
        return this.mapQuery.entrySet().stream().map(s -> new Pair((Object)((String)s.getKey()), (Object)((ServiceDescriptorManager)s.getValue()))).collect(Collectors.toList());
    }
}

