/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.service.config;

import com.cloudimpl.outstack.runtime.EventRepositoryFactory;
import com.cloudimpl.outstack.runtime.EventRepositoy;
import com.cloudimpl.outstack.runtime.configs.ConfigEntity;
import com.cloudimpl.outstack.runtime.configs.ConfigGroupEntity;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ConfigQueryProvider {
    private static final ConfigQueryProvider inst = new ConfigQueryProvider();
    private EventRepositoy<ConfigGroupEntity> eventRepo;

    public static ConfigQueryProvider getInstance() {
        return inst;
    }

    public String getConfig(String configGroup, String configName, String defaultValue) {
        return inst.getRawConfig(null, configGroup, configName, defaultValue);
    }

    public String getConfig(String tenantId, String configGroup, String configName, String defaultValue) {
        return inst.getRawConfig(tenantId, configGroup, configName, defaultValue);
    }

    public int getConfig(String tenantId, String configGroup, String configName, int defaultValue) {
        String val = inst.getRawConfig(tenantId, configGroup, configName, null);
        if (val == null) {
            return defaultValue;
        }
        return Integer.valueOf(val);
    }

    public int getConfig(String configGroup, String configName, int defaultValue) {
        return this.getConfig((String)null, configGroup, configName, defaultValue);
    }

    public boolean getConfig(String tenantId, String configGroup, String configName, boolean defaultValue) {
        String val = inst.getRawConfig(tenantId, configGroup, configName, null);
        if (val == null) {
            return defaultValue;
        }
        return Boolean.valueOf(val);
    }

    public boolean getConfig(String configGroup, String configName, boolean defaultValue) {
        return this.getConfig(null, configGroup, configName, defaultValue);
    }

    public long getConfig(String tenantId, String configGroup, String configName, long defaultValue) {
        String val = inst.getRawConfig(tenantId, configGroup, configName, null);
        if (val == null) {
            return defaultValue;
        }
        return Long.valueOf(val);
    }

    public long getConfig(String configGroup, String configName, long defaultValue) {
        return this.getConfig(null, configGroup, configName, defaultValue);
    }

    private String getRawConfig(String tenantId, String configGroup, String configName, String defaultValue) {
        Optional cg = this.eventRepo.getRootById(ConfigGroupEntity.class, configGroup, tenantId);
        if (cg.isEmpty()) {
            return defaultValue;
        }
        Optional cf = this.eventRepo.getChildById(ConfigGroupEntity.class, ((ConfigGroupEntity)cg.get()).id(), ConfigEntity.class, configName, tenantId);
        if (cf.isEmpty()) {
            return defaultValue;
        }
        return ((ConfigEntity)cf.get()).getConfigValue();
    }

    public void setEventRepositroy(EventRepositoryFactory factory) {
        this.eventRepo = factory.createOrGetRepository(ConfigGroupEntity.class);
    }
}

