/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.util;

import com.cloudimpl.outstack.runtime.ValidationErrorException;
import com.cloudimpl.outstack.runtime.domainspec.FileData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.web.server.ServerErrorException;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);
    private static final Tika tika = new Tika();

    public static void validateMimeType(List<FileData> fileDataList, Set<String> acceptedMimetypes) {
        if (CollectionUtils.isEmpty(fileDataList)) {
            return;
        }
        if (CollectionUtils.isEmpty(acceptedMimetypes)) {
            acceptedMimetypes = Collections.emptySet();
        }
        Set acceptedMimeTypeSet = acceptedMimetypes.stream().filter(org.apache.tika.mime.MimeType::isValid).map(MimeType::valueOf).collect(Collectors.toSet());
        boolean containsInvalidMimeType = fileDataList.stream().map(fileData -> {
            try {
                return MimeType.valueOf((String)tika.detect(fileData.getInputStream()));
            }
            catch (IOException e) {
                throw new ServerErrorException("mimetype detection failure", (Throwable)e);
            }
        }).anyMatch(e -> !acceptedMimeTypeSet.contains(e));
        if (containsInvalidMimeType) {
            throw new ValidationErrorException(String.format("unsupported mimetypes detected. accepts {%s} only", acceptedMimeTypeSet));
        }
    }

    public static FileData getFileData(FilePart filePart) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            FileUtil.getInputStream(filePart).transferTo(byteArrayOutputStream);
        }
        catch (IOException e) {
            throw new ServerErrorException("cannot read file stream", (Throwable)e);
        }
        return new FileData(filePart.filename(), byteArrayOutputStream);
    }

    private static InputStream getInputStream(FilePart filePart) {
        if (filePart == null) {
            return InputStream.nullInputStream();
        }
        return (InputStream)filePart.content().map(DataBuffer::asInputStream).reduce(SequenceInputStream::new).block();
    }

    public static InputStream getInputStream(ByteArrayOutputStream byteArrayOutputStream) {
        if (byteArrayOutputStream == null || byteArrayOutputStream.size() == 0) {
            return InputStream.nullInputStream();
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }
}

