/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime;

import com.cloudimpl.outstack.runtime.ChildEntityQueryContext;
import com.cloudimpl.outstack.runtime.ExternalEntityQueryProvider;
import com.cloudimpl.outstack.runtime.ResultSet;
import com.cloudimpl.outstack.runtime.RootEntityContext;
import com.cloudimpl.outstack.runtime.RootEntityQueryContext;
import com.cloudimpl.outstack.runtime.domainspec.ChildEntity;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.Query;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.function.BiFunction;
import reactor.core.publisher.Mono;

public class AsyncRootEntityQueryContext<T extends RootEntity>
implements RootEntityQueryContext<T> {
    private final RootEntityContext<T> inst;
    private final BiFunction<String, Object, Mono> requestHandler;

    public AsyncRootEntityQueryContext(RootEntityContext<T> inst, BiFunction<String, Object, Mono> requestHandler) {
        this.inst = inst;
        this.requestHandler = requestHandler;
    }

    @Override
    public String getTenantId() {
        return this.inst.getTenantId();
    }

    @Override
    public <C extends ChildEntity<T>> Optional<C> getChildEntityById(Class<C> childType, String id) {
        return this.inst.getChildEntityById(childType, id);
    }

    @Override
    public <C extends ChildEntity<T>> ResultSet<Event<C>> getChildEntityEventsById(Class<C> childType, String id, Query.PagingRequest pageRequest) {
        return this.inst.getChildEntityEventsById(childType, id, pageRequest);
    }

    @Override
    public <C extends ChildEntity<T>> ResultSet<C> getAllChildEntitiesByType(Class<C> childType, Query.PagingRequest pageRequest) {
        return this.inst.getAllChildEntitiesByType(childType, pageRequest);
    }

    @Override
    public Optional<T> getEntity() {
        return this.inst.getEntity();
    }

    @Override
    public ResultSet<T> getAll(Query.PagingRequest pagingRequest) {
        return this.inst.getAll(pagingRequest);
    }

    @Override
    public Optional<T> getEntityById(String id) {
        return this.inst.getEntityById(id);
    }

    @Override
    public RootEntityQueryContext<T> asRootQueryContext() {
        return this.inst.asRootQueryContext();
    }

    @Override
    public <R extends RootEntity, K extends ChildEntity<R>> ChildEntityQueryContext<R, K> asChildQueryContext() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public <R extends RootEntity> ExternalEntityQueryProvider<R> getEntityQueryProvider(Class<R> rootType) {
        return this.inst.getEntityQueryProvider(rootType);
    }

    @Override
    public <R extends RootEntity> ExternalEntityQueryProvider<R> getEntityQueryProvider(Class<R> rootType, String tenantId) {
        return this.inst.getEntityQueryProvider(rootType, tenantId);
    }

    @Override
    public ResultSet<Event<T>> getEntityEventsById(String id, Query.PagingRequest pageRequest) {
        return this.inst.getEntityEventsById(id, pageRequest);
    }

    @Override
    public AsyncRootEntityQueryContext<T> asAsyncQueryContext() {
        return this;
    }

    @Override
    public RootEntityContext<T> asNonTenantContext(String id) {
        return this.inst.asNonTenantContext(id);
    }

    public <T> Mono<T> sendRequest(String domainOwner, String domainContext, String version, String serviceName, Object req) {
        return this.requestHandler.apply(MessageFormat.format("{0}/{1}/{2}/{3}", domainOwner, domainContext, version, serviceName), req);
    }

    @Override
    public boolean isIdExist(String id, String tenantId) {
        return this.inst.isIdExist(id, tenantId);
    }
}

