/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime;

import com.cloudimpl.outstack.runtime.AsyncEntityContext;
import com.cloudimpl.outstack.runtime.CRUDOperations;
import com.cloudimpl.outstack.runtime.ChildEntityContext;
import com.cloudimpl.outstack.runtime.EntityIdHelper;
import com.cloudimpl.outstack.runtime.EntityMetaDetail;
import com.cloudimpl.outstack.runtime.EntityMetaDetailCache;
import com.cloudimpl.outstack.runtime.EntityProvider;
import com.cloudimpl.outstack.runtime.EntityQueryContext;
import com.cloudimpl.outstack.runtime.EntityQueryContextProvider;
import com.cloudimpl.outstack.runtime.ITransaction;
import com.cloudimpl.outstack.runtime.InputMetaProvider;
import com.cloudimpl.outstack.runtime.QueryOperations;
import com.cloudimpl.outstack.runtime.ResultSet;
import com.cloudimpl.outstack.runtime.RootEntityContext;
import com.cloudimpl.outstack.runtime.ServiceProviderException;
import com.cloudimpl.outstack.runtime.UnboundedEntityContext;
import com.cloudimpl.outstack.runtime.ValidationErrorException;
import com.cloudimpl.outstack.runtime.domainspec.ChildEntity;
import com.cloudimpl.outstack.runtime.domainspec.DomainEventException;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.Query;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import com.cloudimpl.outstack.runtime.util.Util;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import reactor.core.publisher.Mono;

public class EntityContextProvider<T extends RootEntity>
extends EntityQueryContextProvider<T> {
    private final EntityProvider entityProvider;
    private final Supplier<BiFunction<String, Object, Mono>> requestHandler;

    public EntityContextProvider(Class<T> type, EntityProvider entityProvider, Supplier<String> idGenerator, QueryOperations<T> queryOperation, Function<Class<? extends RootEntity>, QueryOperations<?>> queryOperationSelector, Supplier<BiFunction<String, Object, Mono>> requestHandler) {
        super(type, idGenerator, queryOperation, queryOperationSelector, requestHandler);
        this.entityProvider = entityProvider;
        this.requestHandler = requestHandler;
    }

    public Transaction<T> createWritableTransaction(String rootTid, String tenantId, boolean async) {
        return new Transaction(this.type, this.entityProvider, this.idGenerator, rootTid, tenantId, this.queryOperation, this::validateObject, this.queryOperationSelector, this.version, async, this.requestHandler);
    }

    public UnboundedTransaction<T> createUnboundedTransaction(String tenantId) {
        return new UnboundedTransaction(this, tenantId, this.idGenerator, this.queryOperation, this::validateObject, this.queryOperationSelector, this.type, this.requestHandler);
    }

    private <T> void validateObject(T target) {
        Set violations = this.validator.validate(target, new Class[0]);
        if (!violations.isEmpty()) {
            ValidationErrorException error = new ValidationErrorException(((ConstraintViolation)violations.stream().findFirst().get()).getMessage());
            throw error;
        }
    }

    public static final class Transaction<R extends RootEntity>
    extends EntityQueryContextProvider.ReadOnlyTransaction<R>
    implements CRUDOperations {
        private final TreeMap<String, Entity> mapBrnEntities = new TreeMap();
        private final TreeMap<String, Entity> mapTrnEntities = new TreeMap();
        private final Map<String, Entity> removeEntites;
        private final Map<String, Entity> renameEntities;
        private final EntityProvider entityProvider;
        private Object reply;
        private final List<Event> eventList;
        private final Supplier<BiFunction<String, Object, Mono>> requestHandler;
        private Object attachment;
        private InputMetaProvider inputMetaProvider;

        public Transaction(Class<R> type, EntityProvider entityProvider, Supplier<String> idGenerator, String rootId, String tenantId, QueryOperations<R> queryOperation, Consumer<Object> validator, Function<Class<? extends RootEntity>, QueryOperations<?>> queryOperationSelector, String version, boolean async, Supplier<BiFunction<String, Object, Mono>> requestHandler) {
            super(type, idGenerator, rootId, tenantId, queryOperation, validator, queryOperationSelector, version, async, requestHandler);
            this.entityProvider = entityProvider;
            this.eventList = new LinkedList<Event>();
            this.requestHandler = requestHandler;
            this.removeEntites = new HashMap<String, Entity>();
            this.renameEntities = new HashMap<String, Entity>();
        }

        @Override
        public void setReply(Object reply) {
            this.reply = reply;
        }

        @Override
        public <K> K getReply() {
            return (K)this.reply;
        }

        @Override
        public List<Event> getEventList() {
            return this.eventList;
        }

        protected void publishEvent(Event event) {
            this.eventList.add(event);
        }

        @Override
        public InputMetaProvider getInputMetaProvider() {
            return this.inputMetaProvider;
        }

        protected Transaction setInputMetaProvider(InputMetaProvider inputMetaProvider) {
            this.inputMetaProvider = inputMetaProvider;
            return this;
        }

        @Override
        public <C extends ChildEntity<R>, K extends Entity, Z extends EntityQueryContext> Z getContext(Class<K> entityType) {
            if (RootEntity.isMyType(entityType)) {
                Class<K> rootType = entityType;
                if (this.async) {
                    return (Z)((EntityQueryContext)new AsyncEntityContext<K>(rootType, this.rootTid, this.tenantId, Optional.of(this::loadEntity), this.idGenerator, Optional.of(this), this, Optional.of(this::publishEvent), this.validator, this.queryOperationSelector, this.version, this.requestHandler.get()).setTx(this));
                }
                return (Z)((EntityQueryContext)new RootEntityContext<K>(rootType, this.rootTid, this.tenantId, Optional.of(this::loadEntity), this.idGenerator, Optional.of(this), this, Optional.of(this::publishEvent), this.validator, this.queryOperationSelector, this.version).setTx(this));
            }
            this.validateRootTid();
            Class rootType = Util.extractGenericParameter(entityType, ChildEntity.class, 0);
            Class<K> childType = entityType;
            return (Z)((EntityQueryContext)new ChildEntityContext(rootType, this.rootTid, childType, this.tenantId, Optional.of(this::loadEntity), this.idGenerator, Optional.of(this), this, Optional.of(this::publishEvent), this.validator, this.queryOperationSelector, this.version).setTx(this));
        }

        public <K extends Entity, C extends ChildEntity<R>> Optional<K> loadEntity(Class<R> rootType, String id, Class<C> childType, String childId, String tenantId) {
            if (childType == null) {
                return this.loadRootEntity(rootType, id, tenantId).or(() -> this.entityProvider.loadEntity(rootType, id, childType, childId, tenantId));
            }
            return this.loadChildEntity(rootType, id, childType, childId, tenantId).or(() -> this.entityProvider.loadEntity(rootType, id, childType, childId, tenantId));
        }

        protected Optional<R> loadRootEntity(Class<R> rootType, String id, String tenantId) {
            if (id.startsWith("id-")) {
                return Optional.ofNullable((RootEntity)this.mapTrnEntities.get(RootEntity.makeTRN(rootType, this.version, id, tenantId)));
            }
            return Optional.ofNullable((RootEntity)this.mapBrnEntities.get(RootEntity.makeRN(rootType, this.version, id, tenantId)));
        }

        protected <C extends ChildEntity<R>> Optional<C> loadChildEntity(Class<R> rootType, String id, Class<C> childType, String childId, String tenantId) {
            EntityIdHelper.validateTechnicalId(id);
            if (childId.startsWith("id-")) {
                return Optional.ofNullable((ChildEntity)this.mapTrnEntities.get(ChildEntity.makeTRN(rootType, this.version, id, childType, childId, tenantId)));
            }
            return Optional.ofNullable((ChildEntity)this.mapBrnEntities.get(ChildEntity.makeRN(rootType, this.version, id, childType, childId, tenantId)));
        }

        public void putEntity(Entity entity) {
            this.mapBrnEntities.put(entity.getBRN(), entity);
            this.mapTrnEntities.put(entity.getTRN(), entity);
            if (entity.isRoot()) {
                if (this.rootTid == null) {
                    this.rootTid = entity.id();
                } else if (!this.rootTid.equals(entity.id())) {
                    throw new ServiceProviderException("multiple root id modification on same transaction not supported. expecting {0} , found {1}", this.rootTid, entity.entityId());
                }
            }
        }

        @Override
        public void create(Entity entity) {
            this.putEntity(entity);
        }

        @Override
        public void update(Entity entity) {
            this.putEntity(entity);
        }

        @Override
        public void delete(Entity entity) {
            this.mapBrnEntities.remove(entity.getBRN());
            this.removeEntites.put(entity.getBRN(), entity);
        }

        @Override
        public void rename(Entity oldEntity, Entity newEntity) {
            this.renameEntities.put(oldEntity.getTRN(), oldEntity);
            this.mapBrnEntities.remove(oldEntity.getBRN());
            this.removeEntites.put(oldEntity.getBRN(), oldEntity);
            this.mapBrnEntities.put(newEntity.getBRN(), newEntity);
            this.mapTrnEntities.put(newEntity.getTRN(), newEntity);
        }

        @Override
        public Optional<R> getRootById(Class<R> rootType, String id, String tenantId) {
            if (id.startsWith("id-")) {
                return Optional.ofNullable((RootEntity)this.mapTrnEntities.get(RootEntity.makeTRN(rootType, this.version, id, tenantId))).or(() -> this.queryOperation.getRootById(rootType, id, tenantId));
            }
            return Optional.ofNullable((RootEntity)this.mapBrnEntities.get(RootEntity.makeRN(rootType, this.version, id, tenantId))).or(() -> this.queryOperation.getRootById(rootType, id, tenantId));
        }

        @Override
        public <T extends ChildEntity<R>> Optional<T> getChildById(Class<R> rootType, String id, Class<T> childType, String childId, String tenantId) {
            EntityIdHelper.validateTechnicalId(id);
            if (childId.startsWith("id-")) {
                return Optional.ofNullable((ChildEntity)this.mapTrnEntities.get(ChildEntity.makeTRN(rootType, this.version, id, childType, id, tenantId))).or(() -> this.queryOperation.getChildById(rootType, id, childType, childId, tenantId));
            }
            return Optional.ofNullable((ChildEntity)this.mapBrnEntities.get(ChildEntity.makeRN(rootType, this.version, id, childType, childId, tenantId))).or(() -> this.queryOperation.getChildById(rootType, id, childType, childId, tenantId));
        }

        @Override
        public <T extends ChildEntity<R>> ResultSet<T> getAllChildByType(Class<R> rootType, String id, Class<T> childType, String tenantId, Query.PagingRequest pageable) {
            HashMap<String, ChildEntity> map = new HashMap<String, ChildEntity>(this.queryOperation.getAllChildByType(rootType, id, childType, tenantId, pageable).getItems().stream().collect(Collectors.toMap(c -> c.getTRN(), c -> c)));
            this.mapTrnEntities.headMap(RootEntity.makeTRN(rootType, this.version, id, tenantId)).entrySet().forEach(p -> map.put((String)p.getKey(), (ChildEntity)p.getValue()));
            Collection out = map.values();
            return new ResultSet(out.size(), (int)Math.ceil((double)out.size() / (double)pageable.pageSize()), pageable.pageNum(), out);
        }

        @Override
        public ResultSet<R> getAllByRootType(Class<R> rootType, String tenantId, Query.PagingRequest paging) {
            return this.queryOperation.getAllByRootType(rootType, tenantId, paging);
        }

        @Override
        public void setAttachment(Object attachment) {
            this.attachment = attachment;
        }

        @Override
        public <K> K getAttachment() {
            return (K)this.attachment;
        }

        @Override
        public Collection<Entity> getEntityList() {
            return this.mapBrnEntities.values();
        }

        @Override
        public Map<String, Entity> getDeletedEntities() {
            return this.removeEntites;
        }

        @Override
        public Map<String, Entity> getRenameEntities() {
            return this.renameEntities;
        }
    }

    public static final class UnboundedTransaction<R extends RootEntity>
    implements ITransaction<R>,
    CRUDOperations {
        private EntityContextProvider entityContextProvider;
        private String tenantId;
        private Supplier<String> idGenerator;
        private QueryOperations<R> queryOperation;
        private Consumer<Object> validator;
        private Function<Class<? extends RootEntity>, QueryOperations<?>> queryOperationSelector;
        private Map<String, ITransaction<R>> transactionMap = new ConcurrentHashMap<String, ITransaction<R>>();
        private EntityMetaDetail entityMetaDetail;
        private InputMetaProvider inputMetaProvider;
        private Object reply;
        private Supplier<BiFunction<String, Object, Mono>> requestHandler;

        public UnboundedTransaction(EntityContextProvider entityContextProvider, String tenantId, Supplier<String> idGenerator, QueryOperations<R> queryOperation, Consumer<Object> validator, Function<Class<? extends RootEntity>, QueryOperations<?>> queryOperationSelector, Class<? extends Entity> entityType, Supplier<BiFunction<String, Object, Mono>> requestHandler) {
            this.entityContextProvider = entityContextProvider;
            this.tenantId = tenantId;
            this.idGenerator = idGenerator;
            this.queryOperation = queryOperation;
            this.validator = validator;
            this.queryOperationSelector = queryOperationSelector;
            this.entityMetaDetail = EntityMetaDetailCache.instance().getEntityMeta(entityType);
            this.requestHandler = requestHandler;
        }

        protected void setInputMetaProvider(InputMetaProvider inputMetaProvider) {
            this.inputMetaProvider = inputMetaProvider;
        }

        public void setReply(Object reply) {
            this.reply = reply;
        }

        @Override
        public List<Event> getEventList() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Collection<Entity> getEntityList() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Map<String, Entity> getDeletedEntities() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Map<String, Entity> getRenameEntities() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setAttachment(Object attachment) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public <K> K getAttachment() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isEntityRenamed(String trn) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Collection<ITransaction<R>> getTxList() {
            return this.transactionMap.values();
        }

        @Override
        public <K> K getReply() {
            return (K)this.reply;
        }

        @Override
        public <C extends ChildEntity<R>, K extends Entity, Z extends EntityQueryContext> Z getContext(Class<K> entityType) {
            if (RootEntity.isMyType(entityType)) {
                Class<K> rootType = entityType;
                return (Z)new UnboundedEntityContext<K>(this.entityContextProvider, rootType, this.tenantId, this.idGenerator, Optional.of(this), this, Optional.of(this::publishEvent), this.validator, this.queryOperationSelector, this.entityMetaDetail.getVersion(), this.requestHandler.get());
            }
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public InputMetaProvider getInputMetaProvider() {
            return this.inputMetaProvider;
        }

        public <K extends Entity, C extends ChildEntity<R>> Optional<K> loadEntity(Class<R> rootType, String id, Class<C> childType, String childId, String tenantId) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void publishEvent(Event event) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public ResultSet<R> getAllByRootType(Class<R> rootType, String tenantId, Query.PagingRequest paging) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Optional<R> getRootById(Class<R> rootType, String id, String tenantId) {
            return this.transactionMap.values().stream().filter(tr -> tr.getRootType() == rootType).map(tx -> tx.getRootById(rootType, id, tenantId)).filter(t -> t.isPresent()).findFirst().orElse(this.queryOperation.getRootById(rootType, id, tenantId));
        }

        @Override
        public <T extends ChildEntity<R>> Optional<T> getChildById(Class<R> rootType, String id, Class<T> childType, String childId, String tenantId) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public <T extends ChildEntity<R>> ResultSet<T> getAllChildByType(Class<R> rootType, String id, Class<T> childType, String tenantId, Query.PagingRequest paging) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public ResultSet<Event<R>> getEventsByRootId(Class<R> rootType, String rootId, String tenantId, Query.PagingRequest paging) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public <T extends ChildEntity<R>> ResultSet<Event<T>> getEventsByChildId(Class<R> rootType, String id, Class<T> childType, String childId, String tenantId, Query.PagingRequest paging) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected ITransaction<R> getTransaction(String rootId) {
            if (EntityIdHelper.isTechnicalId(rootId)) {
                rootId = ((RootEntity)this.queryOperation.getRootById(this.entityMetaDetail.getType(), rootId, this.tenantId).orElseThrow(() -> new DomainEventException(DomainEventException.ErrorCode.ENTITY_NOT_FOUND, "root entity not available for entity {0}", this.entityMetaDetail.getType().getSimpleName()))).entityId();
            }
            String tmpRootId = rootId;
            return this.transactionMap.computeIfAbsent(rootId + ":" + this.tenantId, id -> this.entityContextProvider.createWritableTransaction(tmpRootId, this.tenantId, false).setInputMetaProvider(this.inputMetaProvider));
        }

        protected ITransaction<R> getNonTenantTransaction(String rootId) {
            if (rootId != null && EntityIdHelper.isTechnicalId(rootId)) {
                rootId = ((RootEntity)this.queryOperation.getRootById(this.entityMetaDetail.getType(), rootId, null).orElseThrow(() -> new DomainEventException(DomainEventException.ErrorCode.ENTITY_NOT_FOUND, "root entity not available for entity {0}", this.entityMetaDetail.getType().getSimpleName()))).entityId();
            }
            String tmpRootId = rootId;
            return this.transactionMap.computeIfAbsent(rootId + ":null", id -> this.entityContextProvider.createWritableTransaction(tmpRootId, null, false).setInputMetaProvider(this.inputMetaProvider));
        }

        @Override
        public void create(Entity entity) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void update(Entity entity) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void delete(Entity entity) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void rename(Entity oldEntity, Entity newEntity) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isIdExist(String id, String tenantId) {
            return this.queryOperation.isIdExist(id, tenantId);
        }

        @Override
        public Class<R> getRootType() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

