/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime;

import com.cloudimpl.outstack.runtime.AsyncRootEntityQueryContext;
import com.cloudimpl.outstack.runtime.ChildEntityContext;
import com.cloudimpl.outstack.runtime.EntityIdHelper;
import com.cloudimpl.outstack.runtime.EntityQueryContext;
import com.cloudimpl.outstack.runtime.ITransaction;
import com.cloudimpl.outstack.runtime.InputMetaProvider;
import com.cloudimpl.outstack.runtime.QueryOperations;
import com.cloudimpl.outstack.runtime.ResultSet;
import com.cloudimpl.outstack.runtime.RootEntityContext;
import com.cloudimpl.outstack.runtime.ServiceProviderException;
import com.cloudimpl.outstack.runtime.ValidationErrorException;
import com.cloudimpl.outstack.runtime.domainspec.ChildEntity;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.Query;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import com.cloudimpl.outstack.runtime.util.Util;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import reactor.core.publisher.Mono;

public class EntityQueryContextProvider<T extends RootEntity> {
    protected final QueryOperations<T> queryOperation;
    protected final Supplier<String> idGenerator;
    protected final ValidatorFactory factory;
    protected final Validator validator;
    protected final Function<Class<? extends RootEntity>, QueryOperations<?>> queryOperationSelector;
    protected final Class<T> type;
    protected final String version;
    private final Supplier<BiFunction<String, Object, Mono>> requestHandler;

    public EntityQueryContextProvider(Class<T> type, Supplier<String> idGenerator, QueryOperations<T> queryOperation, Function<Class<? extends RootEntity>, QueryOperations<?>> queryOperationSelector, Supplier<BiFunction<String, Object, Mono>> requestHandler) {
        this.type = type;
        this.version = Entity.getVersion(type);
        this.idGenerator = idGenerator;
        this.queryOperation = queryOperation;
        this.factory = Validation.buildDefaultValidatorFactory();
        this.validator = this.factory.getValidator();
        this.queryOperationSelector = queryOperationSelector;
        this.requestHandler = requestHandler;
    }

    public ReadOnlyTransaction<T> createTransaction(String rootTid, String tenantId, boolean async) {
        return new ReadOnlyTransaction<T>(this.type, this.idGenerator, rootTid, tenantId, this.queryOperation, this::validateObject, this.queryOperationSelector, this.version, async, this.requestHandler);
    }

    private <T> void validateObject(T target) {
        Set violations = this.validator.validate(target, new Class[0]);
        if (!violations.isEmpty()) {
            ValidationErrorException error = new ValidationErrorException(((ConstraintViolation)violations.stream().findFirst().get()).getMessage());
            throw error;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public static class ReadOnlyTransaction<R extends RootEntity>
    implements ITransaction<R> {
        protected final QueryOperations<R> queryOperation;
        protected final String tenantId;
        protected final Supplier<String> idGenerator;
        protected String rootTid;
        protected Object reply;
        protected final Consumer<Object> validator;
        protected final Function<Class<? extends RootEntity>, QueryOperations<?>> queryOperationSelector;
        protected final String version;
        protected final boolean async;
        private Class<R> type;
        private final Supplier<BiFunction<String, Object, Mono>> requestHandler;

        public ReadOnlyTransaction(Class<R> type, Supplier<String> idGenerator, String rootTid, String tenantId, QueryOperations<R> queryOperation, Consumer<Object> validator, Function<Class<? extends RootEntity>, QueryOperations<?>> queryOperationSelector, String version, boolean async, Supplier<BiFunction<String, Object, Mono>> requestHandler) {
            this.idGenerator = idGenerator;
            this.type = type;
            if (rootTid != null) {
                this.rootTid = EntityIdHelper.isTechnicalId(rootTid) ? rootTid : (String)queryOperation.getRootById(type, rootTid, tenantId).map(t -> t.id()).orElse(null);
            }
            this.tenantId = tenantId;
            this.queryOperation = queryOperation;
            this.validator = validator;
            this.queryOperationSelector = queryOperationSelector;
            this.version = version;
            this.async = async;
            this.requestHandler = requestHandler;
        }

        @Override
        public InputMetaProvider getInputMetaProvider() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public String getRootTid() {
            return this.rootTid;
        }

        public void setReply(Object reply) {
            this.reply = reply;
        }

        @Override
        public <K> K getReply() {
            return (K)this.reply;
        }

        @Override
        public <C extends ChildEntity<R>, K extends Entity, Z extends EntityQueryContext> Z getContext(Class<K> entityType) {
            if (RootEntity.isMyType(entityType)) {
                Class<K> rootType = entityType;
                RootEntityContext<K> context = new RootEntityContext<K>(rootType, this.rootTid, this.tenantId, Optional.empty(), this.idGenerator, Optional.empty(), this, Optional.empty(), this.validator, this.queryOperationSelector, this.version);
                return (Z)(this.async ? new AsyncRootEntityQueryContext<K>(context, this.requestHandler.get()) : context);
            }
            this.validateRootTid();
            Class rootType = Util.extractGenericParameter(entityType, ChildEntity.class, 0);
            Class<K> childType = entityType;
            return (Z)new ChildEntityContext(rootType, this.rootTid, childType, this.tenantId, Optional.empty(), this.idGenerator, Optional.empty(), this, Optional.empty(), this.validator, this.queryOperationSelector, this.version);
        }

        protected void validateRootTid() {
            if (this.rootTid == null) {
                throw new ServiceProviderException("{0} not available", this.type.getSimpleName());
            }
        }

        @Override
        public Optional<R> getRootById(Class<R> rootType, String id, String tenantId) {
            if (id.startsWith("id-")) {
                return this.queryOperation.getRootById(rootType, id, tenantId);
            }
            return this.queryOperation.getRootById(rootType, id, tenantId);
        }

        @Override
        public <T extends ChildEntity<R>> Optional<T> getChildById(Class<R> rootType, String id, Class<T> childType, String childId, String tenantId) {
            EntityIdHelper.validateTechnicalId(id);
            if (childId.startsWith("id-")) {
                return this.queryOperation.getChildById(rootType, id, childType, childId, tenantId);
            }
            return this.queryOperation.getChildById(rootType, id, childType, childId, tenantId);
        }

        @Override
        public <T extends ChildEntity<R>> ResultSet<T> getAllChildByType(Class<R> rootType, String id, Class<T> childType, String tenantId, Query.PagingRequest pageable) {
            return this.queryOperation.getAllChildByType(rootType, id, childType, tenantId, pageable);
        }

        @Override
        public ResultSet<R> getAllByRootType(Class<R> rootType, String tenantId, Query.PagingRequest paging) {
            return this.queryOperation.getAllByRootType(rootType, tenantId, paging);
        }

        @Override
        public ResultSet<Event<R>> getEventsByRootId(Class<R> rootType, String rootId, String tenantId, Query.PagingRequest paging) {
            return this.queryOperation.getEventsByRootId(rootType, rootId, tenantId, paging);
        }

        @Override
        public <T extends ChildEntity<R>> ResultSet<Event<T>> getEventsByChildId(Class<R> rootType, String id, Class<T> childType, String childId, String tenantId, Query.PagingRequest paging) {
            return this.queryOperation.getEventsByChildId(rootType, id, childType, childId, tenantId, paging);
        }

        @Override
        public void setAttachment(Object attachment) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public <K> K getAttachment() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<Event> getEventList() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Collection<Entity> getEntityList() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Map<String, Entity> getDeletedEntities() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Map<String, Entity> getRenameEntities() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isIdExist(String id, String tenantId) {
            return this.queryOperation.isIdExist(id, tenantId);
        }

        @Override
        public Class<R> getRootType() {
            return this.type;
        }
    }
}

