/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime;

import com.cloudimpl.outstack.runtime.QueryOperations;
import com.cloudimpl.outstack.runtime.ResultSet;
import com.cloudimpl.outstack.runtime.domainspec.ChildEntity;
import com.cloudimpl.outstack.runtime.domainspec.Query;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import java.util.Collection;
import java.util.Optional;

public class ExternalEntityQueryProvider<R extends RootEntity> {
    private final Class<R> type;
    private final String tenantId;
    private final QueryOperations<R> queryOperations;

    public ExternalEntityQueryProvider(QueryOperations<R> queryOperations, Class<R> type, String tenantId) {
        this.queryOperations = queryOperations;
        this.tenantId = tenantId;
        this.type = type;
    }

    public ResultSet<R> getAllRootByType(Query.PagingRequest pageRequest) {
        return this.queryOperations.getAllByRootType(this.type, this.tenantId, pageRequest);
    }

    public Optional<R> getRoot(String id) {
        return this.queryOperations.getRootById(this.type, id, this.tenantId);
    }

    public <T extends ChildEntity<R>> Optional<T> getChild(String rootId, Class<T> childType, String childId) {
        String tid = rootId;
        if (!tid.startsWith("id-")) {
            tid = ((RootEntity)this.getRoot(rootId).get()).id();
        }
        return this.queryOperations.getChildById(this.type, tid, childType, childId, this.tenantId);
    }

    public <T extends ChildEntity<R>> ResultSet<T> getChildsByType(String rootId, Class<T> childType, Query.PagingRequest pageRequest) {
        String tid = rootId;
        if (!rootId.startsWith("id-")) {
            tid = ((RootEntity)this.getRoot(rootId).get()).id();
        }
        return this.queryOperations.getAllChildByType(this.type, tid, childType, this.tenantId, pageRequest);
    }

    public <T extends ChildEntity<R>> Collection<T> getChildsByType(String rootId, Class<T> childType) {
        return this.getChildsByType(rootId, childType, Query.PagingRequest.EMPTY).getItems();
    }
}

