/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializer;
import com.google.gson.internal.LinkedTreeMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class GsonCodecRuntime {
    private static final ThreadLocal<Gson> THR_GSON = ThreadLocal.withInitial(() -> GsonCodecRuntime.createGson(false));
    private static final ThreadLocal<Gson> THR_GSON_PRINTER = ThreadLocal.withInitial(() -> GsonCodecRuntime.createGson(true));
    private static final ThreadLocal<JsonParser> THR_GSON_PARSER = ThreadLocal.withInitial(() -> new JsonParser());
    private static final Map<Class<?>, Supplier<JsonSerializer<?>>> serializers = new ConcurrentHashMap();
    private static final Map<Class<?>, Supplier<JsonDeserializer<?>>> deSerializers = new ConcurrentHashMap();

    private GsonCodecRuntime() {
    }

    public static void registerTypeAdaptor(Class<?> cls, Supplier<JsonDeserializer<?>> supplierDeserializer, Supplier<JsonSerializer<?>> supplierSerializer) {
        if (supplierSerializer != null) {
            serializers.put(cls, supplierSerializer);
        }
        if (supplierDeserializer != null) {
            deSerializers.put(cls, supplierDeserializer);
        }
    }

    private static Gson createGson(boolean pretty) {
        GsonBuilder builder = new GsonBuilder();
        if (pretty) {
            builder.setPrettyPrinting();
        }
        serializers.entrySet().forEach(s -> builder.registerTypeAdapter((Type)s.getKey(), ((Supplier)s.getValue()).get()));
        deSerializers.entrySet().forEach(s -> builder.registerTypeAdapter((Type)s.getKey(), ((Supplier)s.getValue()).get()));
        return builder.create();
    }

    public static String encode(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        return THR_GSON.get().toJson(obj);
    }

    public static Gson getGson() {
        return THR_GSON.get();
    }

    public static String encodePretty(Object obj) {
        return THR_GSON_PRINTER.get().toJson(obj);
    }

    public static String encodeWithType(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        JsonElement el = GsonCodecRuntime.encodeToJson(obj);
        if (el.isJsonObject()) {
            JsonObject json = el.getAsJsonObject();
            json.addProperty("_type", obj.getClass().getName());
            el = json;
        }
        return THR_GSON.get().toJson(el);
    }

    public static String encodeWithType2(Object obj) {
        JsonElement el = GsonCodecRuntime.encodeToJson(obj);
        if (el.isJsonObject()) {
            JsonObject json = el.getAsJsonObject();
            json.addProperty("_type", obj.getClass().getName());
            el = json;
        }
        return THR_GSON.get().toJson(el);
    }

    public static JsonElement encodeToJsonWithType(Object obj) {
        if (obj instanceof String) {
            return new JsonPrimitive((String)obj);
        }
        JsonElement el = GsonCodecRuntime.encodeToJson(obj);
        if (el.isJsonObject()) {
            el.getAsJsonObject().addProperty("_type", obj.getClass().getName());
        } else {
            JsonObject json = new JsonObject();
            json.add("el", el);
            json.addProperty("_type", obj.getClass().getName());
            el = json;
        }
        return el;
    }

    public static JsonElement encodeToJson(Object obj) {
        if (obj instanceof String) {
            return new JsonPrimitive((String)obj);
        }
        return THR_GSON.get().toJsonTree(obj);
    }

    public static <T> T decode(Class<T> clazz, String data) {
        return (T)THR_GSON.get().fromJson(data, clazz);
    }

    public static JsonObject toJsonObject(String data) {
        return THR_GSON_PARSER.get().parse(data).getAsJsonObject();
    }

    public static JsonElement toJsonElement(String data) {
        return THR_GSON_PARSER.get().parse(data);
    }

    public static <T> T decode(Class<T> clazz, Map<String, String> data) {
        if (clazz == String.class) {
            return data.keySet().stream().filter(key -> !key.startsWith("@")).findFirst().orElse(null);
        }
        if (clazz == Integer.TYPE) {
            return (T)Integer.valueOf(data.keySet().iterator().next());
        }
        JsonElement jsonElement = THR_GSON.get().toJsonTree(data);
        return (T)THR_GSON.get().fromJson(jsonElement, clazz);
    }

    public static <T> T decodeTree(Class<T> clazz, LinkedTreeMap data) {
        JsonElement jsonElement = THR_GSON.get().toJsonTree((Object)data);
        return (T)THR_GSON.get().fromJson(jsonElement, clazz);
    }

    private static boolean isJsonEl(char c) {
        return c == '{' || c == '}' || c == '[' || c == ']';
    }
}

