/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.domain;

import com.cloudimpl.outstack.runtime.domain.DomainContextCreated;
import com.cloudimpl.outstack.runtime.domainspec.DomainEventException;
import com.cloudimpl.outstack.runtime.domainspec.EntityMeta;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.Id;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;

@EntityMeta(plural="DomainContexts", version="v1")
public class DomainContext
extends RootEntity {
    @Id
    private String domainId;
    private String domainOwner;
    private String domainContext;

    public DomainContext(String domainId) {
        this.domainId = domainId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getDomainOwner() {
        return this.domainOwner;
    }

    public String getDomainContext() {
        return this.domainContext;
    }

    @Override
    public String entityId() {
        return this.domainId;
    }

    private void applyEvent(DomainContextCreated domainContextCreated) {
        this.domainContext = domainContextCreated.getDomainContext();
        this.domainOwner = domainContextCreated.getDomainOwner();
    }

    @Override
    protected void apply(Event event) {
        switch (event.getClass().getSimpleName()) {
            case "DomainContextCreated": {
                this.applyEvent((DomainContextCreated)event);
                break;
            }
            default: {
                throw new DomainEventException(DomainEventException.ErrorCode.UNHANDLED_EVENT, "unhandled event:" + event.getClass().getName(), new Object[0]);
            }
        }
    }

    @Override
    public String idField() {
        return "domainId";
    }
}

