/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.domain;

import com.cloudimpl.outstack.runtime.domain.PolicyCreated;
import com.cloudimpl.outstack.runtime.domainspec.DomainEventException;
import com.cloudimpl.outstack.runtime.domainspec.EntityMeta;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.ITenantOptional;
import com.cloudimpl.outstack.runtime.domainspec.Id;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;

@EntityMeta(plural="Policies", version="v1")
public class Policy
extends RootEntity
implements ITenantOptional {
    private String policyContext;
    @Id
    private final String policyName;
    private final String tenantId;
    private String domainOwner;
    private String domainContext;
    private String apiContext;
    private String rootType;

    public Policy(String policyName, String tenantId) {
        this.policyName = policyName;
        this.tenantId = tenantId;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String entityId() {
        return this.policyName;
    }

    public String getPolicyContext() {
        return this.policyContext;
    }

    public String getDomainOwner() {
        return this.domainOwner;
    }

    public String getDomainContext() {
        return this.domainContext;
    }

    public String getApiContext() {
        return this.apiContext;
    }

    public String getRootType() {
        return this.rootType;
    }

    private void applyEvent(PolicyCreated policyCreated) {
        this.policyContext = policyCreated.getPolicyContext();
        this.domainContext = policyCreated.getDomainContext();
        this.domainOwner = policyCreated.getDomainOwner();
        this.apiContext = policyCreated.getApiContext();
        this.rootType = policyCreated.getRootType();
    }

    @Override
    protected void apply(Event event) {
        switch (event.getClass().getSimpleName()) {
            case "PolicyCreated": {
                this.applyEvent((PolicyCreated)event);
                break;
            }
            default: {
                throw new DomainEventException(DomainEventException.ErrorCode.UNHANDLED_EVENT, "unhandled event:" + event.getClass().getName(), new Object[0]);
            }
        }
    }

    @Override
    public String idField() {
        return "policyName";
    }
}

