/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.domainspec;

import com.cloudimpl.outstack.runtime.EntityMetaDetail;
import com.cloudimpl.outstack.runtime.EntityMetaDetailCache;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import com.cloudimpl.outstack.runtime.util.Util;

public class EntityDeleted
extends Event {
    private final String entityType;
    private final String rootType;
    private final String entityId;
    private final String rootEntityId;

    public EntityDeleted(Class<? extends Entity> entityType, Class<? extends RootEntity> rootType, String entityId, String rootEntityId) {
        this.entityType = entityType.getName();
        this.rootType = rootType.getName();
        this.entityId = entityId;
        this.rootEntityId = rootEntityId;
        EntityMetaDetail meta = EntityMetaDetailCache.instance().getEntityMeta(this.getOwner());
        EntityMetaDetail rootMeta = EntityMetaDetailCache.instance().getEntityMeta(this.getRootOwner());
        this._meta.setIdIgnoreCase(meta.isIdIgnoreCase());
        this._meta.setRootIdIgnoreCase(rootMeta.isIdIgnoreCase());
    }

    @Override
    public Class<? extends Entity> getOwner() {
        if (this.entityType != null) {
            return Util.classForName(this.entityType);
        }
        return null;
    }

    @Override
    public Class<? extends RootEntity> getRootOwner() {
        if (this.rootType != null) {
            return Util.classForName(this.rootType);
        }
        return null;
    }

    @Override
    public String entityId() {
        return this.entityId;
    }

    @Override
    public String rootEntityId() {
        return this.rootEntityId;
    }
}

