/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.domainspec;

import com.cloudimpl.outstack.runtime.EntityMetaDetail;
import com.cloudimpl.outstack.runtime.EntityMetaDetailCache;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import com.cloudimpl.outstack.runtime.util.Util;

public class EntityRenamed
extends Event {
    private final String entityType;
    private final String rootType;
    private final String entityId;
    private final String rootId;
    private final String oldEntityId;

    public EntityRenamed(Class<? extends Entity> entityType, Class<? extends RootEntity> rootType, String entityId, String oldEntityId, String rootId) {
        this.entityType = entityType.getName();
        this.rootType = rootType.getName();
        this.entityId = entityId;
        this.rootId = rootId;
        this.oldEntityId = oldEntityId;
        EntityMetaDetail meta = EntityMetaDetailCache.instance().getEntityMeta(this.getOwner());
        EntityMetaDetail rootMeta = EntityMetaDetailCache.instance().getEntityMeta(this.getRootOwner());
        this._meta.setIdIgnoreCase(meta.isIdIgnoreCase());
        this._meta.setRootIdIgnoreCase(rootMeta.isIdIgnoreCase());
    }

    public Class getOwner() {
        if (this.entityType != null) {
            return Util.classForName(this.entityType);
        }
        return null;
    }

    public Class getRootOwner() {
        if (this.rootType != null) {
            return Util.classForName(this.rootType);
        }
        return null;
    }

    @Override
    public String entityId() {
        return this.entityId;
    }

    @Override
    public String rootEntityId() {
        return this.rootId;
    }

    public String getOldEntityId() {
        return this.oldEntityId;
    }
}

