/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.domainspec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class FileData {
    private final String fileName;
    private final ByteArrayOutputStream outputStream;

    public FileData(String fileName, ByteArrayOutputStream outputStream) {
        this.fileName = fileName;
        this.outputStream = outputStream;
    }

    public String getFileName() {
        return this.fileName;
    }

    public ByteArrayOutputStream getOutputStream() {
        return this.outputStream;
    }

    public InputStream getInputStream() {
        if (this.outputStream == null) {
            return ByteArrayInputStream.nullInputStream();
        }
        return new ByteArrayInputStream(this.outputStream.toByteArray());
    }

    public int getContentLength() {
        if (this.outputStream == null) {
            return 0;
        }
        return this.outputStream.toByteArray().length;
    }
}

