/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.repo;

import com.cloudimpl.outstack.runtime.EntityIdHelper;
import com.cloudimpl.outstack.runtime.EntityMetaDetailCache;
import com.cloudimpl.outstack.runtime.EntityQueryContext;
import com.cloudimpl.outstack.runtime.ITransaction;
import com.cloudimpl.outstack.runtime.InputMetaProvider;
import com.cloudimpl.outstack.runtime.QueryOperations;
import com.cloudimpl.outstack.runtime.ResultSet;
import com.cloudimpl.outstack.runtime.domainspec.ChildEntity;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.EntityHelper;
import com.cloudimpl.outstack.runtime.domainspec.EntityRenamed;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.Query;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SimpleTransaction<T extends RootEntity>
implements ITransaction<T> {
    private final Map<String, Entity> mapTrnEntities;
    private final Map<String, Entity> mapBrnEntities;
    private final Map<String, Entity> mapDeleteEntities;
    private final Map<String, Entity> mapRenameEntities;
    private final List<Event> events = new LinkedList<Event>();
    private final Class<? extends RootEntity> rootType;
    private final String version;
    private final QueryOperations<T> queryOperation;

    public SimpleTransaction(Class<? extends RootEntity> rootType, QueryOperations<T> queryOperation) {
        this.mapTrnEntities = new HashMap<String, Entity>();
        this.mapBrnEntities = new HashMap<String, Entity>();
        this.mapRenameEntities = new HashMap<String, Entity>();
        this.mapDeleteEntities = new HashMap<String, Entity>();
        this.rootType = rootType;
        this.queryOperation = queryOperation;
        this.version = EntityMetaDetailCache.instance().getEntityMeta(rootType).getVersion();
    }

    @Override
    public List<Event> getEventList() {
        return this.events;
    }

    public void apply(Event e) {
        this.events.add(e);
        switch (e.getAction()) {
            case CREATE: {
                if (e.isRootEvent()) {
                    Entity root = RootEntity.create(e.getOwner(), e.entityId(), e.tenantId(), e.id());
                    EntityHelper.applyEvent(root, e);
                    this.mapBrnEntities.put(((RootEntity)root).getBRN(), root);
                    this.mapTrnEntities.put(((RootEntity)root).getTRN(), root);
                    break;
                }
                RootEntity root = this.getRootById(e.getRootOwner(), e.rootId(), e.tenantId()).get();
                Entity child = root.createChildEntity(e.getOwner(), e.entityId(), e.id());
                EntityHelper.applyEvent(child, e);
                this.mapBrnEntities.put(((ChildEntity)child).getBRN(), child);
                this.mapTrnEntities.put(((ChildEntity)child).getTRN(), child);
                break;
            }
            case UPDATE: {
                if (e.isRootEvent()) {
                    RootEntity root = (RootEntity)this.getRootById(e.getOwner(), e.id(), e.tenantId()).get();
                    EntityHelper.applyEvent(root, e);
                    this.mapBrnEntities.put(root.getBRN(), root);
                    this.mapTrnEntities.put(root.getTRN(), root);
                    break;
                }
                ChildEntity child = (ChildEntity)this.getChildById(e.getRootOwner(), e.rootId(), (Class)e.getOwner(), e.entityId(), e.tenantId()).get();
                EntityHelper.applyEvent(child, e);
                this.mapBrnEntities.put(child.getBRN(), child);
                this.mapTrnEntities.put(child.getTRN(), child);
                break;
            }
            case DELETE: {
                if (e.isRootEvent()) {
                    RootEntity root = this.getRootById(e.getRootOwner(), e.entityId(), e.tenantId()).get();
                    this.mapDeleteEntities.put(root.getBRN(), root);
                    break;
                }
                ChildEntity child = (ChildEntity)this.getChildById(e.getRootOwner(), e.rootId(), (Class)e.getOwner(), e.entityId(), e.tenantId()).get();
                this.mapDeleteEntities.put(child.getBRN(), child);
                break;
            }
            case RENAME: {
                EntityRenamed renameEvent = (EntityRenamed)e;
                if (e.isRootEvent()) {
                    RootEntity root = this.getRootById(e.getRootOwner(), renameEvent.id(), e.tenantId()).get();
                    RootEntity newRoot = (RootEntity)root.rename(renameEvent.entityId());
                    this.mapRenameEntities.put(root.getTRN(), root);
                    this.mapBrnEntities.put(newRoot.getBRN(), newRoot);
                    this.mapTrnEntities.put(newRoot.getTRN(), newRoot);
                    break;
                }
                ChildEntity child = (ChildEntity)this.getChildById(e.getRootOwner(), e.rootId(), (Class)e.getOwner(), e.id(), e.tenantId()).get();
                ChildEntity newChild = (ChildEntity)child.rename(renameEvent.entityId());
                this.mapRenameEntities.put(child.getTRN(), child);
                this.mapBrnEntities.put(newChild.getBRN(), newChild);
                this.mapTrnEntities.put(newChild.getTRN(), newChild);
                break;
            }
        }
    }

    @Override
    public Collection<Entity> getEntityList() {
        return this.mapBrnEntities.values();
    }

    @Override
    public Map<String, Entity> getDeletedEntities() {
        return this.mapDeleteEntities;
    }

    @Override
    public Map<String, Entity> getRenameEntities() {
        return this.mapRenameEntities;
    }

    @Override
    public void setAttachment(Object attachment) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <K> K getAttachment() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <K> K getReply() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <C extends ChildEntity<T>, K extends Entity, Z extends EntityQueryContext> Z getContext(Class<K> entityType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public InputMetaProvider getInputMetaProvider() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ResultSet<T> getAllByRootType(Class<T> rootType, String tenantId, Query.PagingRequest paging) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Optional<T> getRootById(Class<T> rootType, String id, String tenantId) {
        if (EntityIdHelper.isTechnicalId(id)) {
            return Optional.ofNullable((RootEntity)this.mapTrnEntities.get(RootEntity.makeTRN(rootType, this.version, id, tenantId))).or(() -> this.queryOperation.getRootById(rootType, id, tenantId));
        }
        return Optional.ofNullable((RootEntity)this.mapBrnEntities.get(RootEntity.makeRN(rootType, this.version, id, tenantId))).or(() -> this.queryOperation.getRootById(rootType, id, tenantId));
    }

    @Override
    public <C extends ChildEntity<T>> Optional<C> getChildById(Class<T> rootType, String id, Class<C> childType, String childId, String tenantId) {
        EntityIdHelper.validateTechnicalId(id);
        if (EntityIdHelper.isTechnicalId(childId)) {
            return Optional.ofNullable((ChildEntity)this.mapTrnEntities.get(ChildEntity.makeTRN(rootType, this.version, id, childType, childId, tenantId))).or(() -> this.queryOperation.getChildById(rootType, id, childType, childId, tenantId));
        }
        return Optional.ofNullable((ChildEntity)this.mapBrnEntities.get(ChildEntity.makeRN(rootType, this.version, id, childType, childId, tenantId))).or(() -> this.queryOperation.getChildById(rootType, id, childType, childId, tenantId));
    }

    @Override
    public <C extends ChildEntity<T>> ResultSet<C> getAllChildByType(Class<T> rootType, String id, Class<C> childType, String tenantId, Query.PagingRequest paging) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ResultSet<Event<T>> getEventsByRootId(Class<T> rootType, String rootId, String tenantId, Query.PagingRequest paging) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <C extends ChildEntity<T>> ResultSet<Event<C>> getEventsByChildId(Class<T> rootType, String id, Class<C> childType, String childId, String tenantId, Query.PagingRequest paging) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isIdExist(String id, String tenantId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Class<T> getRootType() {
        return this.rootType;
    }
}

