/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime;

import com.cloudimpl.outstack.runtime.AsyncEntityContext;
import com.cloudimpl.outstack.runtime.CRUDOperations;
import com.cloudimpl.outstack.runtime.ChildEntityContext;
import com.cloudimpl.outstack.runtime.Context;
import com.cloudimpl.outstack.runtime.EntityMetaDetail;
import com.cloudimpl.outstack.runtime.EntityMetaDetailCache;
import com.cloudimpl.outstack.runtime.EntityProvider;
import com.cloudimpl.outstack.runtime.ExternalEntityQueryProvider;
import com.cloudimpl.outstack.runtime.ITransaction;
import com.cloudimpl.outstack.runtime.QueryOperations;
import com.cloudimpl.outstack.runtime.RootEntityContext;
import com.cloudimpl.outstack.runtime.UnboundedEntityContext;
import com.cloudimpl.outstack.runtime.domainspec.ChildEntity;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class EntityContext<T extends Entity>
implements Context {
    private final String tenantId;
    protected final Class<T> entityType;
    private final List<Event> events;
    protected final Optional<EntityProvider<? extends RootEntity>> entitySupplier;
    protected final Supplier<String> idGenerator;
    protected final Optional<CRUDOperations> crudOperations;
    protected final QueryOperations<?> queryOperation;
    protected final Optional<Consumer<Event>> eventPublisher;
    protected ITransaction tx;
    protected final Consumer<Object> validator;
    protected final Function<Class<? extends RootEntity>, QueryOperations<?>> queryOperationSelector;
    protected final String version;
    protected EntityMetaDetail entityMeta;

    public EntityContext(Class<T> entityType, String tenantId, Optional<EntityProvider<? extends RootEntity>> entitySupplier, Supplier<String> idGenerator, Optional<CRUDOperations> crudOperations, QueryOperations<?> queryOperation, Optional<Consumer<Event>> eventPublisher, Consumer<Object> validator, Function<Class<? extends RootEntity>, QueryOperations<?>> queryOperationSelector, String version) {
        this.tenantId = tenantId;
        this.events = new LinkedList<Event>();
        this.entityType = entityType;
        this.entitySupplier = entitySupplier;
        this.idGenerator = idGenerator;
        this.crudOperations = crudOperations;
        this.eventPublisher = eventPublisher;
        this.queryOperation = queryOperation;
        this.validator = validator;
        this.queryOperationSelector = queryOperationSelector;
        this.version = version;
        this.entityMeta = EntityMetaDetailCache.instance().getEntityMeta(entityType);
    }

    public ITransaction getTx() {
        return this.tx;
    }

    protected String getVersion() {
        return this.version;
    }

    protected <R extends RootEntity> EntityProvider<R> getEntityProvider() {
        return this.entitySupplier.get();
    }

    protected <R extends RootEntity> QueryOperations<R> getQueryOperations() {
        return this.queryOperation;
    }

    public <X extends EntityContext> X setTx(ITransaction tx) {
        this.tx = tx;
        return (X)this;
    }

    public Consumer<Event> getEventPublisher() {
        return this.eventPublisher.get();
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    protected CRUDOperations getCrudOperations() {
        return this.crudOperations.get();
    }

    protected void addEvent(Event<T> event) {
        this.events.add(event);
    }

    protected EntityMetaDetail getEntityMeta() {
        return this.entityMeta;
    }

    public abstract T create(String var1, Event<T> var2);

    public abstract T update(String var1, Event<T> var2);

    public abstract T delete(String var1);

    public abstract T rename(String var1, String var2);

    public abstract <R extends RootEntity> RootEntityContext<R> asRootContext();

    public abstract <R extends RootEntity> AsyncEntityContext<R> asAsyncEntityContext();

    public <R extends RootEntity> UnboundedEntityContext<R> asUnboundedEntityContext() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public abstract <R extends RootEntity, K extends ChildEntity<R>> ChildEntityContext<R, K> asChildContext();

    public <R extends RootEntity> ExternalEntityQueryProvider<R> getEntityQueryProvider(Class<R> rootType) {
        return new ExternalEntityQueryProvider(this.queryOperationSelector.apply(rootType), rootType, Collections.singletonList(this.getTenantId()));
    }

    public <R extends RootEntity> ExternalEntityQueryProvider<R> getEntityQueryProviderFromTenantList(Class<R> rootType, Collection<String> tenantId) {
        return new ExternalEntityQueryProvider(this.queryOperationSelector.apply(rootType), rootType, tenantId);
    }

    public <R extends RootEntity> ExternalEntityQueryProvider<R> getEntityQueryProvider(Class<R> rootType, String tenantId) {
        return this.getEntityQueryProviderFromTenantList(rootType, Collections.singletonList(tenantId));
    }
}

