/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime.domainspec;

import com.cloudimpl.outstack.runtime.EntityIdHelper;
import com.cloudimpl.outstack.runtime.EntityMetaDetail;
import com.cloudimpl.outstack.runtime.EntityMetaDetailCache;
import com.cloudimpl.outstack.runtime.common.GsonCodecRuntime;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.IResource;
import com.cloudimpl.outstack.runtime.domainspec.Input;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import java.text.MessageFormat;

public abstract class Event<T extends Entity>
implements IResource,
Input {
    private String _tenantId;
    private long _seqNum;
    private String _id;
    private String _rootId;
    private Action _action;
    protected Meta _meta = new Meta();

    public Event() {
        if (this.getOwner() != null) {
            EntityMetaDetail meta = EntityMetaDetailCache.instance().getEntityMeta(this.getOwner());
            EntityMetaDetail rootMeta = EntityMetaDetailCache.instance().getEntityMeta(this.getRootOwner());
            this._meta.setIdIgnoreCase(meta.isIdIgnoreCase());
            this._meta.setVersion(rootMeta.getVersion());
            this._meta.setRootIdIgnoreCase(rootMeta.isIdIgnoreCase());
        }
    }

    public void setTenantId(String tenantId) {
        this._tenantId = tenantId;
    }

    public void setSeqNum(long seq) {
        this._seqNum = seq;
    }

    public String persistedId() {
        EntityMetaDetail meta = EntityMetaDetailCache.instance().getEntityMeta(this.getOwner());
        return meta.isIdIgnoreCase() ? this.entityId().toLowerCase() : this.entityId();
    }

    public String rootPersistedId() {
        EntityMetaDetail meta = EntityMetaDetailCache.instance().getEntityMeta(this.getRootOwner());
        return meta.isIdIgnoreCase() ? this.rootEntityId().toLowerCase() : this.rootEntityId();
    }

    public void setAction(Action action) {
        this._action = action;
    }

    public long getSeqNum() {
        return this._seqNum;
    }

    public Action getAction() {
        return this._action;
    }

    public Meta getMeta() {
        return this._meta;
    }

    public boolean isConsumed() {
        return this._action != null;
    }

    public void setRootId(String rootId) {
        EntityIdHelper.validateTechnicalId(rootId);
        this._rootId = rootId;
    }

    public void setId(String id) {
        EntityIdHelper.validateTechnicalId(id);
        this._id = id;
    }

    @Override
    public final String tenantId() {
        return this._tenantId;
    }

    public final String id() {
        return this._id;
    }

    public final String rootId() {
        return this._rootId;
    }

    public abstract Class<? extends Entity> getOwner();

    public abstract Class<? extends RootEntity> getRootOwner();

    public abstract String entityId();

    public abstract String rootEntityId();

    @Override
    public String getTRN() {
        if (RootEntity.isMyType(this.getOwner())) {
            if (this.tenantId() != null) {
                return MessageFormat.format("tenant/{0}/{1}/{2}/{3}/{4}/{5}", this.tenantId(), this.getMeta().getVersion(), this.getOwner().getSimpleName(), this.id(), this.getClass().getSimpleName(), this.getSeqNum());
            }
            return MessageFormat.format("{0}/{1}/{2}/{3}/{4}", this.getMeta().getVersion(), this.getOwner().getSimpleName(), this.id(), this.getClass().getSimpleName(), this.getSeqNum());
        }
        if (this.tenantId() != null) {
            return MessageFormat.format("tenant/{0}/{1}/{2}/{3}/{4}/{5}/{6}/{7}", this.tenantId(), this.getMeta().getVersion(), this.getRootOwner().getSimpleName(), this.rootId(), this.getOwner().getSimpleName(), this.id(), this.getClass().getSimpleName(), this.getSeqNum());
        }
        return MessageFormat.format("{0}/{1}/{2}/{3}/{4}/{5}/{6}", this.getMeta().getVersion(), this.getRootOwner().getSimpleName(), this.rootId(), this.getOwner().getSimpleName(), this.id(), this.getClass().getSimpleName(), this.getSeqNum());
    }

    @Override
    public String getBRN() {
        if (RootEntity.isMyType(this.getOwner())) {
            if (this.tenantId() != null) {
                return MessageFormat.format("tenant/{0}/{1}/{2}/{3}/{4}/{5}", this.tenantId(), this.getMeta().getVersion(), this.getOwner().getSimpleName(), this.persistedId(), this.getClass().getSimpleName(), this.getSeqNum());
            }
            return MessageFormat.format("{0}/{1}/{2}/{3}/{4}", this.getMeta().getVersion(), this.getOwner().getSimpleName(), this.persistedId(), this.getClass().getSimpleName(), this.getSeqNum());
        }
        if (this.tenantId() != null) {
            return MessageFormat.format("tenant/{0}/{1}/{2}/{3}/{4}/{5}/{6}/{7}", this.tenantId(), this.getMeta().getVersion(), this.getRootOwner().getSimpleName(), this.rootId(), this.getOwner().getSimpleName(), this.persistedId(), this.getClass().getSimpleName(), this.getSeqNum());
        }
        return MessageFormat.format("{0}/{1}/{2}/{3}/{4}/{5}/{6}", this.getMeta().getVersion(), this.getRootOwner().getSimpleName(), this.rootId(), this.getOwner().getSimpleName(), this.persistedId(), this.getClass().getSimpleName(), this.getSeqNum());
    }

    public String getEntityTRN() {
        if (RootEntity.isMyType(this.getOwner())) {
            if (this.tenantId() != null) {
                return MessageFormat.format("tenant/{0}/{1}/{2}/{3}", this.tenantId(), this.getMeta().getVersion(), this.getOwner().getSimpleName(), this.id());
            }
            return MessageFormat.format("{0}/{1}/{2}", this.getMeta().getVersion(), this.getOwner().getSimpleName(), this.id());
        }
        if (this.tenantId() != null) {
            return MessageFormat.format("tenant/{0}/{1}/{2}/{3}/{4}/{5}", this.tenantId(), this.getMeta().getVersion(), this.getRootOwner().getSimpleName(), this.rootId(), this.getOwner().getSimpleName(), this.id());
        }
        return MessageFormat.format("{0}/{1}/{2}/{3}/{4}", this.getMeta().getVersion(), this.getRootOwner().getSimpleName(), this.rootId(), this.getOwner().getSimpleName(), this.id());
    }

    public String getEntityRN() {
        if (RootEntity.isMyType(this.getOwner())) {
            if (this.tenantId() != null) {
                return MessageFormat.format("tenant/{0}/{1}/{2}/{3}", this.tenantId(), this.getMeta().getVersion(), this.getOwner().getSimpleName(), this.persistedId());
            }
            return MessageFormat.format("{0}/{1}/{2}", this.getMeta().getVersion(), this.getOwner().getSimpleName(), this.persistedId());
        }
        if (this.tenantId() != null) {
            return MessageFormat.format("tenant/{0}/{1}/{2}/{3}/{4}/{5}", this.tenantId(), this.getMeta().getVersion(), this.getRootOwner().getSimpleName(), this.rootId(), this.getOwner().getSimpleName(), this.persistedId());
        }
        return MessageFormat.format("{0}/{1}/{2}/{3}/{4}", this.getMeta().getVersion(), this.getRootOwner().getSimpleName(), this.rootId(), this.getOwner().getSimpleName(), this.persistedId());
    }

    public String getRootEntityTRN() {
        if (this.tenantId() != null) {
            return MessageFormat.format("tenant/{0}/{1}/{2}/{3}", this.tenantId(), this.getMeta().getVersion(), this.getRootOwner().getSimpleName(), this.rootId());
        }
        return MessageFormat.format("{0}/{1}/{2}", this.getMeta().getVersion(), this.getRootOwner().getSimpleName(), this.rootId());
    }

    public String getRootEntityRN() {
        if (this.tenantId() != null) {
            return MessageFormat.format("tenant/{0}/{1}/{2}/{3}", this.tenantId(), this.getMeta().getVersion(), this.getRootOwner().getSimpleName(), this.rootPersistedId());
        }
        return MessageFormat.format("{0}/{1}/{2}", this.getMeta().getVersion(), this.getRootOwner().getSimpleName(), this.rootPersistedId());
    }

    public boolean isRootEvent() {
        return this.getRootOwner() == this.getOwner();
    }

    public String toString() {
        return GsonCodecRuntime.encode(this);
    }

    public static final class Meta {
        private long createdDate;
        private String version;
        private boolean idIgnoreCase;
        private boolean rootIdIgnoreCase;
        private String userId;
        private String userName;

        protected void setCreatedDate(long createdDate) {
            this.createdDate = createdDate;
        }

        protected void setVersion(String version) {
            this.version = version;
        }

        public long getCreatedDate() {
            return this.createdDate;
        }

        public void setIdIgnoreCase(boolean ignoreCase) {
            this.idIgnoreCase = ignoreCase;
        }

        public void setRootIdIgnoreCase(boolean rootIgnoreCase) {
            this.rootIdIgnoreCase = rootIgnoreCase;
        }

        public long createdDate() {
            return this.createdDate;
        }

        public String getVersion() {
            return this.version;
        }

        public String getUserId() {
            return this.userId;
        }

        protected void setUserId(String userId) {
            this.userId = userId;
        }

        public String getUserName() {
            return this.userName;
        }

        protected void setUserName(String userName) {
            this.userName = userName;
        }
    }

    public static enum Action {
        CREATE,
        UPDATE,
        DELETE,
        RENAME;

    }
}

