/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime;

import com.cloudimpl.outstack.runtime.CommandException;
import com.cloudimpl.outstack.runtime.CommandHandler;
import com.cloudimpl.outstack.runtime.CommandResponse;
import com.cloudimpl.outstack.runtime.EntityContext;
import com.cloudimpl.outstack.runtime.EntityContextProvider;
import com.cloudimpl.outstack.runtime.InputMetaProvider;
import com.cloudimpl.outstack.runtime.domainspec.Command;
import com.cloudimpl.outstack.runtime.domainspec.DomainEventException;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.ICommand;
import com.cloudimpl.outstack.runtime.domainspec.TenantRequirement;
import com.cloudimpl.outstack.runtime.util.Util;

public abstract class EntityCommandHandler<T extends Entity, I extends Command, R>
implements CommandHandler<T> {
    public static final CommandResponse OK = new CommandResponse("OK");
    protected final Class<T> entityType;
    protected final Class<I> cmdType;

    public EntityCommandHandler() {
        this.entityType = Util.extractGenericParameter(this.getClass(), EntityCommandHandler.class, 0);
        this.cmdType = Util.extractGenericParameter(this.getClass(), EntityCommandHandler.class, 1);
    }

    public EntityCommandHandler(Class<T> type) {
        this.entityType = type;
        this.cmdType = Util.extractGenericParameter(this.getClass(), EntityCommandHandler.class, 1);
    }

    public TenantRequirement getTenantRequirement() {
        return Entity.checkTenantRequirement(this.entityType);
    }

    public R apply(EntityContext<T> context, I command) {
        this.validateInput(command);
        return this.execute(context, command);
    }

    protected abstract R execute(EntityContext<T> var1, I var2);

    protected void validateInput(I command) {
        if (this.getTenantRequirement() == TenantRequirement.REQUIRED && ((Command)command).tenantId() == null) {
            throw new CommandException("tenantId is not available in the request", new Object[0]);
        }
    }

    protected EntityContext<T> emit(EntityContextProvider contextProvider, ICommand input) {
        if (!contextProvider.getVersion().equals(input.version())) {
            throw new DomainEventException(DomainEventException.ErrorCode.INVALID_VERSION, "invalid version {0} ,expecting {1}", input.version(), contextProvider.getVersion());
        }
        I cmd = input.unwrap(this.cmdType);
        this.validateInput(cmd);
        EntityContextProvider.Transaction tx = contextProvider.createWritableTransaction(((Command)cmd).rootId(), this.getTenantRequirement() == TenantRequirement.NONE ? null : ((Command)cmd).tenantId(), false);
        tx.setInputMetaProvider(new InputMetaProvider(){
            final /* synthetic */ Command val$cmd;
            {
                this.val$cmd = command;
            }

            @Override
            public String getUserName() {
                return this.val$cmd.getMapAttr().get("userName");
            }

            @Override
            public String getUserId() {
                return this.val$cmd.getMapAttr().get("userId");
            }
        });
        EntityContext context = (EntityContext)tx.getContext(this.entityType);
        context.setTx(tx);
        R reply = this.apply(context, cmd);
        tx.setReply(reply);
        return context;
    }

    public static CommandResponse OK() {
        return OK;
    }
}

