/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.runtime;

import com.cloudimpl.outstack.runtime.CommandException;
import com.cloudimpl.outstack.runtime.CommandHandler;
import com.cloudimpl.outstack.runtime.EntityContext;
import com.cloudimpl.outstack.runtime.EntityContextProvider;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.util.Util;

public abstract class EntityEventHandler<T extends Entity, E extends Event<?>>
implements CommandHandler<T> {
    private final Class<T> enityType = Util.extractGenericParameter(this.getClass(), EntityEventHandler.class, 0);
    private final Class<E> eventType = Util.extractGenericParameter(this.getClass(), EntityEventHandler.class, 1);

    public boolean isTenantFunction() {
        return Entity.hasTenant(this.enityType);
    }

    public void accept(EntityContext<T> context, E event) {
        this.validateInput((Event<?>)event);
        this.execute(context, event);
    }

    protected abstract void execute(EntityContext<T> var1, E var2);

    private void validateInput(Event<?> event) {
        if (this.isTenantFunction() && event.tenantId() == null) {
            throw new CommandException("tenantId is not available in the request", new Object[0]);
        }
    }

    protected EntityContext<T> emit(EntityContextProvider.Transaction tx, E event) {
        EntityContext context = (EntityContext)tx.getContext(this.enityType);
        context.setTx(tx);
        this.accept(context, event);
        return context;
    }
}

